/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.helper;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TypesHelper {
    private static final Logger log = LoggerFactory.getLogger(TypesHelper.class);
    private static final String[] sortedTypeNames = new String[]{"ARRAY", "BIGINT", "BINARY", "BIT", "BLOB", "BOOLEAN", "CHAR", "CLOB", "DATALINK", "DATE", "DECIMAL", "DISTINCT", "DOUBLE", "FLOAT", "INTEGER", "JAVA_OBJECT", "LONGVARBINARY", "LONGVARCHAR", "NULL", "NUMERIC", "OTHER", "REAL", "REF", "SMALLINT", "STRUCT", "TIME", "TIMESTAMP", "TIMESTAMP_WITH_TIMEZONE", "TINYINT", "VARBINARY", "VARCHAR"};
    private static final int[] sortedTypes = new int[]{2003, -5, -2, -7, 2004, 16, 1, 2005, 70, 91, 3, 2001, 8, 6, 4, 2000, -4, -1, 0, 2, 1111, 7, 2006, 5, 2002, 92, 93, 2014, -6, -3, 12};

    public static String typeToString(int type) {
        switch (type) {
            case 2003: {
                return "ARRAY";
            }
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 2004: {
                return "BLOB";
            }
            case 16: {
                return "BOOLEAN";
            }
            case -15: 
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 70: {
                return "DATALINK";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -16: 
            case -1: {
                return "LONGVARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL";
            }
            case 2006: {
                return "REF";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case 2014: {
                return "TIMESTAMP_WITH_TIMEZONE";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case -9: 
            case 12: {
                return "VARCHAR";
            }
        }
        return null;
    }

    public static int stringToType(String s) {
        if (s == null) {
            return 1111;
        }
        int i0 = 0;
        int i1 = sortedTypeNames.length;
        while (i1 > i0) {
            int i = i0 + (i1 - i0) / 2;
            int r = sortedTypeNames[i].compareToIgnoreCase(s);
            if (r == 0) {
                return sortedTypes[i];
            }
            if (r < 0) {
                i0 = i + 1;
                continue;
            }
            i1 = i;
        }
        if (i0 < sortedTypeNames.length && sortedTypeNames[i0].compareToIgnoreCase(s) == 0) {
            return sortedTypes[i0];
        }
        return 1111;
    }

    public static boolean isNumeric(int type) {
        return type == -5 || type == 3 || type == 8 || type == 6 || type == 4 || type == 2 || type == 7 || type == 5 || type == -6 || type == 16 || type == -7;
    }

    public static boolean isString(int type) {
        return type == 1 || type == -15 || type == 12 || type == -9;
    }

    public static short deferrabilityStringToShort(String s) {
        if (s == null || "NotDeferrable".equals(s)) {
            return 7;
        }
        if ("InitiallyDeferred".equals(s)) {
            return 5;
        }
        if ("InitiallyImmediate".equals(s)) {
            return 6;
        }
        log.warn("Invalid deferrability string [" + s + "] specified; assuming default value [NotDeferrable].");
        return 7;
    }

    public static String deferrabilityShortToString(short s) {
        switch (s) {
            case 7: {
                return "NotDeferrable";
            }
            case 5: {
                return "InitiallyDeferred";
            }
            case 6: {
                return "InitiallyImmediate";
            }
        }
        log.warn("Invalid deferrability value [" + s + "] specified; assuming default value [NotDeferrable].");
        return "NotDeferrable";
    }

    public static short fkRuleStringToShort(String s) {
        if (s == null || "NoAction".equals(s)) {
            return 3;
        }
        if ("Cascade".equals(s)) {
            return 0;
        }
        if ("Restrict".equals(s)) {
            return 1;
        }
        if ("SetDefault".equals(s)) {
            return 4;
        }
        if ("SetNull".equals(s)) {
            return 2;
        }
        log.warn("Invalid foreign key rule string [" + s + "] specified; assuming default value [NoAction].");
        return 3;
    }

    public static String fkRuleShortToString(short s) {
        switch (s) {
            case 3: {
                return "NoAction";
            }
            case 0: {
                return "Cascade";
            }
            case 1: {
                return "Restrict";
            }
            case 4: {
                return "SetDefault";
            }
            case 2: {
                return "SetNull";
            }
        }
        log.warn("Invalid foreign key rule value [" + s + "] specified; assuming default value [NoAction].");
        return "NoAction";
    }
}

