/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.helper;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import org.clazzes.jdbc2xml.sql.SqlIdentifierMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SQLHelper {
    private static final Logger log = LoggerFactory.getLogger(SQLHelper.class);

    public static void quoteISOSqlString(StringBuffer sb, String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\'') {
                sb.append('\'');
            }
            sb.append(c);
        }
    }

    public static String unquoteISOSqlString(String s) {
        return s.replace("''", "'");
    }

    public static void appendTypePrec(StringBuffer sb, String type, Integer prec) {
        sb.append(type);
        if (prec != null) {
            sb.append('(');
            sb.append(prec);
            sb.append(')');
        }
    }

    public static void appendTypePrecScale(StringBuffer sb, String type, Integer prec, Integer scale) {
        sb.append(type);
        if (prec != null) {
            sb.append('(');
            sb.append(prec);
            if (scale != null) {
                sb.append(',');
                sb.append(scale);
            }
            sb.append(')');
        }
    }

    public static void executeUpdate(Connection connection, String sql) throws SQLException {
        try (Statement statement = connection.createStatement();){
            if (log.isTraceEnabled()) {
                log.trace("executeUpdate sql=[" + sql + "].");
            }
            try {
                statement.executeUpdate(sql);
            }
            catch (SQLException e) {
                throw new SQLException("Error in query [" + sql + "]", e.getSQLState(), e.getErrorCode(), e);
            }
        }
    }

    public static ResultSet executeQuerie(Connection connection, String sql) throws SQLException {
        try (Statement statement = connection.createStatement();){
            if (log.isTraceEnabled()) {
                log.trace("executeUpdate sql=[" + sql + "].");
            }
            try {
                ResultSet result;
                ResultSet resultSet = result = statement.executeQuery(sql);
                return resultSet;
            }
            catch (SQLException e) {
                throw new SQLException("Error in query [" + sql + "]", e.getSQLState(), e.getErrorCode(), e);
            }
        }
    }

    public static void copyResultField(PreparedStatement ps, int pc, ResultSet rs, int rc) throws SQLException {
        ResultSetMetaData md = rs.getMetaData();
        int type = md.getColumnType(rc);
        switch (type) {
            case 2003: {
                Array a = rs.getArray(rc);
                if (rs.wasNull()) {
                    ps.setNull(pc, type);
                    break;
                }
                ps.setArray(pc, a);
                break;
            }
            case -5: 
            case 2: 
            case 3: 
            case 7: {
                BigDecimal bd = rs.getBigDecimal(rc);
                if (rs.wasNull()) {
                    ps.setNull(pc, type);
                    break;
                }
                ps.setBigDecimal(pc, bd);
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                byte[] ba = rs.getBytes(rc);
                if (rs.wasNull()) {
                    ps.setNull(pc, type);
                    break;
                }
                ps.setBytes(pc, ba);
                break;
            }
            case -7: {
                byte by = rs.getByte(rc);
                if (rs.wasNull()) {
                    ps.setNull(pc, type);
                    break;
                }
                ps.setByte(pc, by);
                break;
            }
            case 16: {
                boolean bo = rs.getBoolean(rc);
                if (rs.wasNull()) {
                    ps.setNull(pc, type);
                    break;
                }
                ps.setBoolean(pc, bo);
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                String str = rs.getString(rc);
                if (rs.wasNull()) {
                    ps.setNull(pc, type);
                    break;
                }
                ps.setString(pc, str);
                break;
            }
            case 91: {
                Date dat = rs.getDate(rc);
                if (rs.wasNull()) {
                    ps.setNull(pc, type);
                    break;
                }
                ps.setDate(pc, dat);
                break;
            }
            case 6: 
            case 8: {
                double dbl = rs.getDouble(rc);
                if (rs.wasNull()) {
                    ps.setNull(pc, type);
                    break;
                }
                ps.setDouble(pc, dbl);
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                long intg = rs.getLong(rc);
                if (rs.wasNull()) {
                    ps.setNull(pc, type);
                    break;
                }
                ps.setLong(pc, intg);
                break;
            }
            case 2006: {
                Ref ref = rs.getRef(rc);
                if (rs.wasNull()) {
                    ps.setNull(pc, type);
                    break;
                }
                ps.setRef(pc, ref);
                break;
            }
            case 92: {
                Time time = rs.getTime(rc);
                if (rs.wasNull()) {
                    ps.setNull(pc, type);
                    break;
                }
                ps.setTime(pc, time);
                break;
            }
            case 93: 
            case 2014: {
                Timestamp timestamp = rs.getTimestamp(rc);
                if (rs.wasNull()) {
                    ps.setNull(pc, type);
                    break;
                }
                ps.setTimestamp(pc, timestamp);
                break;
            }
            default: {
                Object obj = rs.getObject(rc);
                if (rs.wasNull()) {
                    ps.setNull(pc, type);
                    break;
                }
                ps.setObject(pc, obj);
            }
        }
    }

    public static void joinIdentifiers(StringBuffer sb, Collection<String> strings, SqlIdentifierMapper mapper) {
        boolean firstItem = true;
        for (String s : strings) {
            if (firstItem) {
                firstItem = false;
            } else {
                sb.append(',');
            }
            sb.append(mapper.toExternal(s));
        }
    }

    public static String joinIdentifiers(Collection<String> strings, SqlIdentifierMapper mapper) {
        StringBuffer sb = new StringBuffer();
        SQLHelper.joinIdentifiers(sb, strings, mapper);
        return sb.toString();
    }
}

