/***********************************************************
 * $Id$
 * 
 * JDB to XML bridge of the clazzes project.
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Created: 24.06.2008
 * 
 ***********************************************************/

package org.clazzes.jdbc2xml.sql.impl;

import java.util.Locale;

import org.clazzes.jdbc2xml.sql.SqlIdentifierMapper;
import org.clazzes.jdbc2xml.sql.SqlIdentifierMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * The default SQL identifier mapper factory implementation.
 * 
 * @author wglas
 */
public class SqlIdentifierMapperFactoryImpl extends SqlIdentifierMapperFactory {

    private static final Logger log = LoggerFactory.getLogger(SqlIdentifierMapperFactoryImpl.class);

    /* (non-Javadoc)
     * @see org.clazzes.jdbc2xml.sql.SqlIdentifierMapperFactory#newMapper(java.lang.String)
     */
    public SqlIdentifierMapper newMapper(String key) {
        
        if ("lower".equals(key)) {
            
            return new SqlIdentifierMapper() {
                public String toExternal(String identifier) {
                    return identifier.toLowerCase(Locale.US);
                }
            };
        }
        else if ("upper".equals(key)) {
            
            return new SqlIdentifierMapper() {
                public String toExternal(String identifier) {
                    return identifier.toUpperCase(Locale.US);
                }
            };
        }
        else {
            
            if (key != null && !"id".equals(key))
                log.warn("Unsupported key ["+key+"], returning the id mapper.");
            
            return new SqlIdentifierMapper() {
                public String toExternal(String identifier) {
                    return identifier;
                }
            };           
        }
    }
}
