/***********************************************************
 * $Id$
 *
 * JDB to XML bridge of the clazzes project.
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Created: 24.06.2008
 *
 ***********************************************************/

package org.clazzes.jdbc2xml.sql;

import org.clazzes.jdbc2xml.helper.ServiceHelper;
import org.clazzes.jdbc2xml.sql.impl.SqlIdentifierMapperFactoryImpl;

/**
 * @author wglas
 *
 */
public abstract class SqlIdentifierMapperFactory implements ISqlIdentifierMapperFactory {

    /**
     * @return The first implementation registered under the resource path
     *         <code>META-INF/services/org.clazzes.jdbc2xml.sql.SqlIdentifierMapperFactory</code>.
     */
    public static ISqlIdentifierMapperFactory newInstance() {
        return ServiceHelper.loadService(SqlIdentifierMapperFactory.class,SqlIdentifierMapperFactoryImpl::new);
    }

}
