/***********************************************************
 * $Id$
 * 
 * JDB to XML bridge of the clazzes project.
 * http://www.clazzes.org
 *
 * Created: 27.11.2007
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.jdbc2xml.sql;


/**
 * A mapper for transforming SQL identifiers from the database to the
 * representation in the XML file.
 * 
 * Instances are used to transform identifiers of case-insensitive RDBMS
 * systems to lower or upper case. 
 * 
 * @author wglas
 */
public interface SqlIdentifierMapper {

    /**
     * @param identifier The SQL identifier as reported by the JDBC driver.
     * @return The external form of the SQL identifier as written to the XML file.
     */
    public String toExternal(String identifier);
}
