/***********************************************************
 * $$Id$$
 * 
 * J2EE-Sandbox classes of the clazzes.org project
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.jdbc2xml.sql;

public interface ISqlIdentifierMapperFactory {

    /**
     * @param key The name of the mapper. Currently, <code>id</code>, <code>lower</code>
     *            and <code>upper</code> are supported. The <code>id</code> mapper performs
     *            no transformation, the <code>lower</code>
     *            and <code>upper</code> mappers perform a lower case resp. upper case
     *            transformation of the identifiers. If name is <code>null</code> or
     *            and unknown name is specified the <code>id</code> mapper is instantiated
     *            and returned.
     *            
     * @return A mapper for SQL identifiers to their external representation.
     */
    public abstract SqlIdentifierMapper newMapper(String key);

}
