/***********************************************************
 * $Id$
 * 
 * JDB to XML bridge of the clazzes project.
 * http://www.clazzes.org
 *
 * Created: 26.11.2007
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.jdbc2xml.serialization.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.TimeZone;

import org.clazzes.jdbc2xml.serialization.SerializationHandler;
import org.clazzes.util.datetime.ISO8601Format;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/**
 * @author wglas
 *
 */
public class TimestampSerializationHandler implements SerializationHandler {

    private java.sql.Timestamp value;
    private Calendar calendar;
    private ISO8601Format df;
    
    public TimestampSerializationHandler(TimeZone timeZone)
    {
        this.value = null;
        this.calendar = Calendar.getInstance(timeZone);
        this.df = new ISO8601Format(ISO8601Format.MILLISECOND_FORMAT_NO_TZ);
    }
    
    /* (non-Javadoc)
     * @see org.clazzes.jdbc2xml.serialization.SerializationHandler#fetchData(java.sql.ResultSet, int)
     */
    public void fetchData(ResultSet rs, int column) throws SQLException {
                
        this.value = rs.getTimestamp(column,this.calendar);
        if (this.value != null)
            this.calendar.setTime(this.value);
    }

    /* (non-Javadoc)
     * @see org.clazzes.jdbc2xml.serialization.SerializationHandler#isNull()
     */
    public boolean isNull() {
        
        return this.value == null;
    }

    /* (non-Javadoc)
     * @see org.clazzes.jdbc2xml.serialization.SerializationHandler#pushData(org.xml.sax.ContentHandler)
     */
    public void pushData(ContentHandler handler) throws SAXException {
        
        String s = this.df.format(this.calendar);
        handler.characters(s.toCharArray(),0,s.length());
    }
}
