/***********************************************************
 * $Id$
 * 
 * JDB to XML bridge of the clazzes project.
 * http://www.clazzes.org
 *
 * Created: 26.11.2007
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.jdbc2xml.serialization.impl;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.clazzes.jdbc2xml.serialization.SerializationHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/**
 * @author wglas
 *
 */
public class StringSerializationHandler implements SerializationHandler {

    private String value;
    
    public StringSerializationHandler()
    {
        this.value = null;
    }
    
    /* (non-Javadoc)
     * @see org.clazzes.jdbc2xml.serialization.SerializationHandler#fetchData(java.sql.ResultSet, int)
     */
    public void fetchData(ResultSet rs, int column) throws SQLException {
        
        this.value = rs.getString(column);
    }

    /* (non-Javadoc)
     * @see org.clazzes.jdbc2xml.serialization.SerializationHandler#isNull()
     */
    public boolean isNull() {
        
        return this.value == null;
    }

    /* (non-Javadoc)
     * @see org.clazzes.jdbc2xml.serialization.SerializationHandler#pushData(org.xml.sax.ContentHandler)
     */
    public void pushData(ContentHandler handler) throws SAXException {
        
        handler.characters(this.value.toCharArray(),0,this.value.length());
    }
}
