/***********************************************************
 * $Id$
 * 
 * JDB to XML bridge of the clazzes project.
 * http://www.clazzes.org
 *
 * Created: 26.11.2007
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.jdbc2xml.serialization.impl;

import java.sql.Types;
import java.util.TimeZone;

import org.clazzes.jdbc2xml.schema.ColumnInfo;
import org.clazzes.jdbc2xml.serialization.SerializationHandler;
import org.clazzes.jdbc2xml.serialization.SerializationHandlerFactory;

/**
 * The default SerializationHandlerFactory implementation.
 * 
 * @author wglas
 */
public class SerializationHandlerFactoryImpl extends
        SerializationHandlerFactory {

    /* (non-Javadoc)
     * @see org.clazzes.jdbc2xml.serialization.SerializationHandlerFactory#newSerializationHandler(org.clazzes.jdbc2xml.schema.ColumnInfo, java.util.TimeZone)
     */
    public SerializationHandler newSerializationHandler(ColumnInfo ci, TimeZone timeZone)
    {    
        switch (ci.getType())
        {
        case Types.SMALLINT:
        case Types.INTEGER:
        case Types.TINYINT:
            return new IntegerSerializationHandler();
            
        case Types.DOUBLE:
            return new DoubleSerializationHandler();
            
        case Types.FLOAT:
            return new FloatSerializationHandler();
            
        case Types.BIGINT:
        case Types.DECIMAL:
        case Types.REAL:
        case Types.NUMERIC:
            return new BigDecimalSerializationHandler();
            
        case Types.LONGVARCHAR:
        case Types.VARCHAR:
        case Types.LONGNVARCHAR:
        case Types.NVARCHAR:
        case Types.CHAR:
        case Types.NCHAR:
        case Types.CLOB:
        case Types.NCLOB:
        case Types.DISTINCT:
                return new StringSerializationHandler();
            
        case Types.DATE:
            return new DateSerializationHandler(timeZone);
            
        case Types.TIMESTAMP:
        case Types.TIMESTAMP_WITH_TIMEZONE:
            return new TimestampSerializationHandler(timeZone);

        case Types.LONGVARBINARY:
        case Types.VARBINARY:
        case Types.BINARY:
        case Types.BLOB:
            return new BinarySerializationHandler();

        case Types.BOOLEAN:
        case Types.BIT:
            return new BooleanSerializationHandler(); 
        }
        
        return null;
    } 
}
