/***********************************************************
 * $Id$
 * 
 * JDB to XML bridge of the clazzes project.
 * http://www.clazzes.org
 *
 * Created: 26.11.2007
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.jdbc2xml.serialization;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/**
 * A SerializationHandler instance handles the serialization
 * of a database column to the CDATA content of an XML tag.
 * 
 * @author wglas
 */
public interface SerializationHandler {

    /**
     * Set the data to be serialized from the given column of an SQL result set.
     * After this call, {@link #isNull()} or {@link #fetchData(ResultSet, int)} may be called.
     * @throws SQLException 
     */
    void fetchData(ResultSet rs, int column) throws SQLException;
    
    /**
     * @return Whether the data received through {@link #fetchData(ResultSet, int)}
     *         is a SQL null value.
     */
    boolean isNull();
    
    /**
     * Write the data of the database value to the CDATA content of the currently open tag
     * by calling {@link ContentHandler#characters(char[], int, int)}.
     * 
     * This call resets the state of this handler, so {@link #fetchData(ResultSet, int)} my be called
     * again.
     * 
     * @param handler The ContentHandler to push the characters to.
     * @throws SAXException 
     */ 
    void pushData(ContentHandler handler) throws SAXException;
}
