/***********************************************************
 * $Id$
 *
 * JDB to XML bridge of the clazzes project.
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Created: 23.08.2010
 *
 ***********************************************************/

package org.clazzes.jdbc2xml.schema.impl;

import org.clazzes.jdbc2xml.schema.DialectFactory;
import org.clazzes.jdbc2xml.schema.IDialectFactory;
import org.clazzes.jdbc2xml.schema.ISchemaEngine;
import org.clazzes.jdbc2xml.schema.ISchemaEngineFactory;

/**
 * A schema factory implementation, which is mainly used for providing a
 * singleton OSGi factory service for {@link ISchemaEngine} instances.
 *
 */
public class SchemaEngineFactoryImpl implements ISchemaEngineFactory {

    private IDialectFactory dialectFactory;

    public SchemaEngineFactoryImpl() {
        this.dialectFactory = new DialectFactoryImpl();
    }

    /* (non-Javadoc)
     * @see org.clazzes.jdbc2xml.schema.ISchemaEngineFactory#newSchemaEngine()
     */
    public ISchemaEngine newSchemaEngine() {

        return new SchemaEngineImpl(this.dialectFactory);
    }

    /**
     * @return the dialectFactory
     */
    public IDialectFactory getDialectFactory() {
        return this.dialectFactory;
    }

    /**
     * @param dialectFactory the dialectFactory to set
     */
    public void setDialectFactory(IDialectFactory dialectFactory) {
        this.dialectFactory = dialectFactory;
    }

}
