/***********************************************************
 * $Id$
 * 
 * JDB to XML bridge of the clazzes project.
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Created: 28.09.2009
 * 
 ***********************************************************/

package org.clazzes.jdbc2xml.schema.impl;

import org.clazzes.jdbc2xml.schema.ISchemaEngine;

/**
 * @author rbreuss
 *
 */
public class NameHelper {

    public static String buildTempTableName(ISchemaEngine schemaEngine, String tableName, String columnName, String suffix)
    {
        String delimiter = "__";
        String schema = schemaEngine.getSchema();
        schema = ((schema == null || schema.length() == 0) ? "JDBC2XML" : schema);
        int maxNameLength = schemaEngine.getMaxTableNameLength();
        if (suffix == null)
            suffix = "";
        StringBuilder tmp = null;new StringBuilder();
        int run = 0;
        do
        {
            tmp = new StringBuilder();
            switch (run)
            {
            case 0:
                tmp.append(schema);
                tmp.append(delimiter);
                tmp.append(tableName);
                tmp.append(delimiter);
                if (columnName != null)
                {
                    tmp.append(columnName);
                    tmp.append(delimiter);
                }
                tmp.append(suffix);
                break;
            case 1:
                delimiter = "_";
                tmp.append(schema);
                tmp.append(delimiter);
                tmp.append(tableName);
                tmp.append(delimiter);
                if (columnName != null)
                {
                    tmp.append(columnName);
                    tmp.append(delimiter);
                }
                tmp.append(suffix);
                break;
            default:
                delimiter = "_";
                tmp.append(shortString(schema, run -1));
                tmp.append(delimiter);
                tmp.append(shortString(tableName, run -1));
                tmp.append(delimiter);
                if (columnName != null)
                {
                    tmp.append(shortString(columnName, run -1));
                    tmp.append(delimiter);
                }
                tmp.append(suffix);
                break;
            }
            run ++;
        }
        while (tmp.length() > maxNameLength);
        return tmp.toString();
    }
    
    private static String shortString(String src, int factor)
    {
        String res = src;
        if (src == null)
            return "";
        if (src.length() < 3)
            return src;
        for (int i=0; i<factor; i++)
        {
            res = res.substring(0, res.length() / 3) + res.substring(res.length() / 3 * 2, res.length());
        }
        return res;
    }
}
