/* **********************************************************
 * $Id$
 * 
 * JDB to XML bridge of the clazzes project.
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Created: 15.08.2017
 * 
 ***********************************************************/

package org.clazzes.jdbc2xml.schema.impl;

/**
 * This s the MariaDB 10.x dialect, which is based on the MySQL 5 dialect,
 * but modifies the driver name and the URL scheme.
 */
public class MariaDBDialect extends MySQLDialect {

    public static final String defaultDriverName="org.mariadb.jdbc.Driver";

    /* (non-Javadoc)
     * @see org.clazzes.jdbc2xml.schema.impl.MySQLDialect#getID()
     */
    @Override
    public String getID() {
        
        return "MARIADB_10";
    }

    protected String getUrlScheme() {
        return "jdbc:mariadb";
    }

    /* (non-Javadoc)
     * @see org.clazzes.jdbc2xml.schema.impl.MySQLDialect#defaultDriverName()
     */
    @Override
    public String defaultDriverName() {
        
        return defaultDriverName;
    }

    
}
