/***********************************************************
 * $Id$
 * 
 * JDB to XML bridge of the clazzes project.
 * http://www.clazzes.org
 *
 * Created: 27.11.2007
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.jdbc2xml.schema.impl;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;

import org.clazzes.jdbc2xml.schema.Dialect;
import org.clazzes.jdbc2xml.schema.DialectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * The default dialect factory exported as OSGi service or
 * provided through {@link DialectFactory#newInstance()}.
 */
public class DialectFactoryImpl extends DialectFactory {

    private static Logger log = LoggerFactory.getLogger(DialectFactoryImpl.class);
    
    /**
     * 
     */
    public DialectFactoryImpl() {
        // nil
    }

    public Dialect newDialect(DatabaseMetaData databaseMetaData)
            throws SQLException {
        if (databaseMetaData.getDatabaseProductName().contains(
                "MySQL")) {
            
            if (databaseMetaData.getDriverName().contains("MariaDB")) {
                return new MariaDBDialect();
            }
            else {
                return new MySQLDialect();
            }
        }
        
        if (databaseMetaData.getDatabaseProductName().contains("MariaDB")) {
            
            MariaDBDialect r = new MariaDBDialect();
            r.setProperty(MySQLDialect.UNQUOTE_DEFAULT_VALUES_PROPERTY,"true");
            return r;
        }
        
        if (databaseMetaData.getDatabaseProductName().contains(
                "Microsoft SQL Server")) {
            return new MSSQLServerDialect();
        }
        if (databaseMetaData.getDatabaseProductName().contains(
                "Apache Derby")) {
            return new DerbyDialect();
        }
        if (databaseMetaData.getDatabaseProductName().contains("Oracle")) {
            return new OracleDialect();
        }
        if (databaseMetaData.getDatabaseProductName().contains("PostgreSQL")) {
            return new PostgreSQLDialect();
        }
        log.error("newDialect(databaseMetaData): Could not determine dialect for database Product ["+databaseMetaData.getDatabaseProductName()+"].");
        return null;
    }

    public Dialect newDialect(String databaseURL) throws SQLException {
        if (databaseURL.startsWith("jdbc:mysql")) {
            return new MySQLDialect();
        }
        else if (databaseURL.startsWith("jdbc:mariadb")) {
            return new MariaDBDialect();
        }
        else if (databaseURL.startsWith("jdbc:sqlserver")) {
            return new MSSQLServerDialect();
        }
        else if (databaseURL.startsWith("jdbc:derby")) {
            return new DerbyDialect();
        }
        else if (databaseURL.startsWith("jdbc:oracle")) {
            return new OracleDialect();
        }
        else if (databaseURL.startsWith("jdbc:postgresql")) {
            return new PostgreSQLDialect();
        }
        log.error("newDialect(databaseURL): Could not determine dialect for database URL ["+databaseURL+"].");
        return null;
    }

}
