/***********************************************************
 * $Id$
 * 
 * JDB to XML bridge of the clazzes project.
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Created: 18.09.2015
 * 
 ***********************************************************/

package org.clazzes.jdbc2xml.schema.impl;

import java.util.HashMap;
import java.util.Map;

import org.clazzes.jdbc2xml.schema.Dialect;

/**
 *  A common base class for all dialects.
 */
public abstract class AbstrDialectSupport implements Dialect {

    private Map<String,String> properties;
    
    @Override
    public void setProperty(String key, String value) {

        if (this.properties == null) {
            this.properties = new HashMap<String,String>();
        }
        
        this.properties.put(key,value);
    }

    @Override
    public void setProperties(Map<String,String> keyValues) {
        
        if (keyValues == null) {
            return;
        }
        
        if (this.properties == null) {
            this.properties = new HashMap<String,String>();
        }
        
        this.properties.putAll(keyValues);
    }

    @Override
    public String getProperty(String key) {

        if (this.properties == null) {
            return null;
        }
        else {
            return this.properties.get(key);
        }
    }

}
