/***********************************************************
 * $Id$
 * 
 * JDB to XML bridge of the clazzes project.
 * http://www.clazzes.org
 *
 * Created: 28.11.2007
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.jdbc2xml.schema;

/**
 * This class holds structural information about a table
 * and a foreign key depth.
 * 
 * @author wglas
 */
public class SortableTableDescription implements Comparable<SortableTableDescription>
{
    private TableInfo tableInfo;
    private int fkDepth;
    
    /**
     * Default constructor
     */
    public SortableTableDescription()
    { }

    /**
     * Default constructor
     */
    public SortableTableDescription(TableInfo tableInfo)
    { 
        this.tableInfo = tableInfo;
        this.fkDepth = -1;
    }

    /**
     * @return the tableInfo
     */
    public TableInfo getTableInfo() {
        return this.tableInfo;
    }

    /**
     * @param tableInfo the tableInfo to set
     */
    public void setTableInfo(TableInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    /**
     * @return the fkDepth
     */
    public int getFkDepth() {
        return this.fkDepth;
    }

    /**
     * @param fkDepth the fkDepth to set
     */
    public void setFkDepth(int fkDepth) {
        this.fkDepth = fkDepth;
    }
    
    /* (non-Javadoc)
     * @see java.lang.Comparable#compareTo(java.lang.Object)
     */
    public int compareTo(SortableTableDescription o) {
        return this.fkDepth - o.fkDepth;
    }
}
