/***********************************************************
 * $Id$
 *
 * JDB to XML bridge of the clazzes project.
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Created: 11.01.2012
 *
 ***********************************************************/

package org.clazzes.jdbc2xml.schema;

/**
 * An exception, which is thrown, when schema management fails.
 */
public class SchemaManagementException extends RuntimeException {

    private static final long serialVersionUID = 9147356598877307978L;

    /**
     * Empty default constructor.
     */
    public SchemaManagementException() {
    }

    /**
     * @param message A detail message.
     */
    public SchemaManagementException(String message) {
        super(message);
    }

    /**
     * @param cause The cause of this exception.
     */
    public SchemaManagementException(Throwable cause) {
        super(cause);
    }

    /**
     * @param message A detail message.
     * @param cause The cause of this exception.
     */
    public SchemaManagementException(String message, Throwable cause) {
        super(message, cause);
    }

}
