/***********************************************************
 * $Id$
 * 
 * JDB to XML bridge of the clazzes project.
 * http://www.clazzes.org
 *
 * Created: 14.12.2007
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.jdbc2xml.schema;

/**
 * This interface is used to configure the set of indices retrieved from the
 * database metadata.
 * 
 * @author rbreuss
 */
public interface IndexFilter {
    
    /**
     * @return Whether we should keep indices generated by the RDBMS,
     *         which are covering primary key / and or foreign
     *         key columns.
     */
    public boolean isKeepInternalIndices();
    
    /**
     * <p>Checking for auto-increment columns is a tedious process, which
     * incurs querying a table using <code>select * from TABLE</code>.
     * </p>
     * <p>There are situations, where this check is too risky or the user
     * knows, that there are no auto-increment column in the database
     * to dump.
     * </p>
     * <p>In such situation, set this option to the non-default value
     * <code>false</code>.
     * </p>
     * @return Whether to check for auto-increment columns.
     */
    public boolean isCheckForAutoIncrementColumns();
}
