/***********************************************************
 * $Id$
 * 
 * JDB to XML bridge of the clazzes project.
 * http://www.clazzes.org
 *
 * Created: 07.08.2007
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.jdbc2xml.schema;

import java.sql.SQLException;

import org.clazzes.jdbc2xml.schema.ISchemaEngine;

/**
 * This interface encapsulates a schema update part, which increments the
 * schema version.
 */
public interface ISchemaUpdateSnippet
{
    /**
     * @return The target version after the update.
     */
    public String getTargetVersion();
    
    /**
     * @return The update comment to be added to the database.
     */
    public String getUpdateComment();
    
    /**
     * Perform the schema update.
     * 
     * @param schemaEngine The JDBC connection.
     */
    public void performUpdate(ISchemaEngine schemaEngine) throws SQLException;
}
