/***********************************************************
 * $Id$
 * 
 * JDB to XML bridge of the clazzes project.
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Created: 22.08.2010
 * 
 ***********************************************************/

package org.clazzes.jdbc2xml.schema;

/**
 * An interface implemented by a singleton bean, that creates a
 * stateful {@link ISchemaEngine} implementation.
 * 
 * This interface is mainly useful for registering an OSGi singleton service.
 * In other environments the functionality of this factory interface is supplied by
 * {@link SchemaEngine#newInstance()}, which acts as a factory method.
 */
public interface ISchemaEngineFactory {

    /**
     * @return A new schema engine instance with a  
     */
    public ISchemaEngine newSchemaEngine();
}
