/***********************************************************
 * $$Id$$
 * 
 * J2EE-Sandbox classes of the clazzes.org project
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.jdbc2xml.schema;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;

public interface IDialectFactory {
    
    /**
     * Return {@link Dialect} instance according to the given database meta
     * data.
     * 
     * @param databaseMetaData
     *            Database meta data of an according {@link Connection}.
     * @return A suitable Dialect instance.
     * @throws SQLException
     */
    abstract public Dialect newDialect(DatabaseMetaData databaseMetaData)
            throws SQLException;

    /**
     * Return {@link Dialect} instance according to the given database url.
     * 
     * @param databaseURL a JDBC URL.
     * @return A suitable Dialect instance, if guessing was possible.
     * @throws SQLException
     */
    abstract public Dialect newDialect(String databaseURL) throws SQLException;

}
