/***********************************************************
 * $Id$
 * 
 * JDB to XML bridge of the clazzes project.
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Created: 25.09.2009
 * 
 ***********************************************************/

package org.clazzes.jdbc2xml.schema;



/**
 * Exception to be thrown whenever a data type is not supported.
 * 
 * @see java.sql.Types
 * @see Dialect
 * @author rbreuss
 * 
 */
public class DataTypeNotSupportedException extends RuntimeException {

    private static final long serialVersionUID = -7884776417650052236L;

    /**
     * Create a new instance.
     * @param dialectDataType Dialect specific String representation of data type. 
     */
    public DataTypeNotSupportedException(String dialectDataType) {
        super("Dialect data type [" + dialectDataType + "] not supported.");
    }

    /**
     * Create a new instance.
     * @param jdbcType JDBC data type as defined in {@link java.sql.Types}
     */
    public DataTypeNotSupportedException(int jdbcType) {
        super("JDBC data type [" + jdbcType + "] not supported.");
    }

}
