/***********************************************************
 * $Id$
 * 
 * JDB to XML bridge of the clazzes project.
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Created: 07.10.2009
 * 
 ***********************************************************/

package org.clazzes.jdbc2xml.sax.impl;

/**
 * @author rbreuss
 *
 */
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class ZipEntryResolver implements EntityResolver {
    
    private static final Logger log = LoggerFactory.getLogger(ZipEntryResolver.class);


    private final ZipFile zipFile;
    
    public  ZipEntryResolver(final ZipFile zipFile)
    {
        this.zipFile = zipFile;
    }
    /*
     * (non-Javadoc)
     * 
     * @see org.xml.sax.EntityResolver#resolveEntity(java.lang.String,
     * java.lang.String)
     */
    public InputSource resolveEntity(String publicId, String systemId) 
    {
        if (log.isDebugEnabled())
            log.debug("resolveEntity: publicId=[" + publicId + "], systemId=[" + systemId + "]");
        String part = systemId;
        int pos = part.lastIndexOf(File.separatorChar);
        if (pos >= 0)
        {
            part = part.substring(pos + 1);            
        }

        ZipEntry zipEntry = this.zipFile.getEntry(part);
        try {
            InputSource isrc = new InputSource(this.zipFile.getInputStream(zipEntry));
            isrc.setPublicId(publicId);
            // Not setting the systemId will cause a NullPointerException, parsing the document !
            isrc.setSystemId(systemId);
            return isrc;
        } catch (IOException e) {
            log.error("Error resolving ZipEntry [" + systemId + "].");
        }
        return null;
    }
}
