/***********************************************************
 * $Id$
 * 
 * JDB to XML bridge of the clazzes project.
 * http://www.clazzes.org
 *
 * Created: 08.12.2007
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.jdbc2xml.sax.impl;

import java.sql.Connection;
import java.sql.SQLException;

import org.clazzes.jdbc2xml.Constants;
import org.clazzes.jdbc2xml.schema.TableInfo;
import org.clazzes.util.xml.SAXTagHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/**
 * A handler for the columnset element.
 * 
 * @author wglas
 */
public class RowSetTagHandler implements SAXTagHandler {

    private InsertContext context;
    private TableInfo tableInfo;
    private RowTagHandler rowTagHandler;
    private boolean oldAutoCommit;
    
    /**
     * @param tableInfo The table information to which we add new columns.
     */
    public RowSetTagHandler(InsertContext context, TableInfo tableInfo) {
        super();
        this.context = context;
        this.tableInfo = tableInfo;
        this.rowTagHandler = null;
    }

    /* (non-Javadoc)
     * @see org.clazzes.util.xml.SAXTagHandler#closeTag(java.lang.String, java.lang.String, java.lang.String)
     */
    public void closeTag(String uri, String localName, String name)
            throws SAXException {
        if (this.rowTagHandler != null) {
            this.rowTagHandler.flush(true);
        }
        
        if (this.context.getProcessRestrictionFilter().isTransactional()) {
            try {
                Connection conn = this.context.getSchemaEngine().getConnection();
                conn.setAutoCommit(this.oldAutoCommit);
                
            } catch (SQLException e) {
                throw new SAXException("Unable to reset auto commit to ["+this.oldAutoCommit+"] for bulk inserts of table ["+this.tableInfo.getName()+"]",e);
            }
        }

    }

    /* (non-Javadoc)
     * @see org.clazzes.util.xml.SAXTagHandler#processCharacters(char[], int, int)
     */
    public void processCharacters(char[] ch, int start, int length)
            throws SAXException {
    }

    /* (non-Javadoc)
     * @see org.clazzes.util.xml.SAXTagHandler#startChildElement(java.lang.String, java.lang.String, java.lang.String, org.xml.sax.Attributes)
     */
    public SAXTagHandler startChildElement(String uri, String localName,
            String name, Attributes atts) throws SAXException {
      
        if (!Constants.JDBC2XML_NS_URI.equals(uri))
            throw new SAXException("Namspace URI ["+uri+"] is not supported.");

        if (Constants.ROW_TAG_NAME.equals(localName)) {
            
            if (this.rowTagHandler == null) {
                
                this.rowTagHandler = new RowTagHandler(this.context,this.tableInfo);
                
                if (this.context.getProcessRestrictionFilter().isTransactional()) {
                    try {
                        Connection conn = this.context.getSchemaEngine().getConnection();
                        this.oldAutoCommit = conn.getAutoCommit();
                        conn.setAutoCommit(false);
                        
                    } catch (SQLException e) {
                        throw new SAXException("Unable to start transaction for bulk inserts of table ["+this.tableInfo.getName()+"]",e);
                    }
                }
            }
            return this.rowTagHandler;
        }
        else
            throw new SAXException("rowset child element ["+localName+"] is not supported.");
    }

}
