/***********************************************************
 * $Id$
 * 
 * JDB to XML bridge of the clazzes project.
 * http://www.clazzes.org
 *
 * Created: 09.12.2007
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.jdbc2xml.sax.impl;

import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;

import org.clazzes.jdbc2xml.schema.ISchemaEngine;
import org.clazzes.jdbc2xml.schema.TableInfo;
import org.clazzes.jdbc2xml.tools.ProcessRestrictionFilter;

/**
 * This class holds all properties used for processing a dump file.
 * 
 * @author wglas
 */
public class InsertContext {
    
    private ISchemaEngine schemaEngine;
    private ProcessRestrictionFilter processRestrictionFilter;
    private List<TableInfo> parsedTables;
    
    /**
     * @param schemaEngine The engine used for schema creation,
     *                     which additionally carries the default time zone.
     */
    public InsertContext(ISchemaEngine schemaEngine) {
        super();
        this.schemaEngine = schemaEngine;
    }

    /**
     * @return the schemaEngine
     */
    public ISchemaEngine getSchemaEngine() {
        return this.schemaEngine;
    }

    /**
     * @param schemaEngine the schemaEngine to set
     */
    public void setSchemaEngine(ISchemaEngine schemaEngine) {
        this.schemaEngine = schemaEngine;
    }

    /**
     * @return the timeZone
     */
    public TimeZone getTimeZone() {
        return this.schemaEngine.getTimeZone();
    }

    /**
     * @param timeZone the timeZone to set
     */
    public void setTimeZone(TimeZone timeZone) {
        this.schemaEngine.setTimeZone(timeZone);
    }

    /**
     * @return the parsedTables
     */
    public List<TableInfo> getParsedTables() {
        return this.parsedTables;
    }

    /**
     * @param parsedTables the parsedTables to set
     */
    public void setParsedTables(List<TableInfo> parsedTables) {
        this.parsedTables = parsedTables;
    }
    
    /**
     * Add a table info to the list of parsed tables.
     * 
     * @param ti The table info to add.
     */
    public void addParsedTable(TableInfo ti) {
        
        if (this.parsedTables == null)
            this.parsedTables = new LinkedList<TableInfo>();
            
        this.parsedTables.add(ti);
    }

    /**
     * @return the processRestrictionFilter
     */
    public ProcessRestrictionFilter getProcessRestrictionFilter() {
        return this.processRestrictionFilter;
    }

    /**
     * @param processRestrictionFilter the processRestrictionFilter to set
     */
    public void setProcessRestrictionFilter(
            ProcessRestrictionFilter processRestrictionFilter) {
        this.processRestrictionFilter = processRestrictionFilter;
    }
}
