/***********************************************************
 * $Id$
 * 
 * JDB to XML bridge of the clazzes project.
 * http://www.clazzes.org
 *
 * Created: 08.12.2007
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.jdbc2xml.sax.impl;

import org.clazzes.jdbc2xml.Constants;
import org.clazzes.jdbc2xml.schema.ForeignKeyInfo;
import org.clazzes.jdbc2xml.schema.TableInfo;
import org.clazzes.util.xml.SAXTagHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/**
 * A handler for the foreignkeyset element.
 * 
 * @author wglas
 */
public class ForeignKeySetTagHandler implements SAXTagHandler {

    private TableInfo tableInfo;
    
    /**
     * @param tableInfo The table information to which we add new columns.
     */
    public ForeignKeySetTagHandler(TableInfo tableInfo) {
        super();
        this.tableInfo = tableInfo;
    }

    /* (non-Javadoc)
     * @see org.clazzes.util.xml.SAXTagHandler#closeTag(java.lang.String, java.lang.String, java.lang.String)
     */
    public void closeTag(String uri, String localName, String name)
            throws SAXException {
    }

    /* (non-Javadoc)
     * @see org.clazzes.util.xml.SAXTagHandler#processCharacters(char[], int, int)
     */
    public void processCharacters(char[] ch, int start, int length)
            throws SAXException {
    }

    /* (non-Javadoc)
     * @see org.clazzes.util.xml.SAXTagHandler#startChildElement(java.lang.String, java.lang.String, java.lang.String, org.xml.sax.Attributes)
     */
    public SAXTagHandler startChildElement(String uri, String localName,
            String name, Attributes atts) throws SAXException {
      
        if (!Constants.JDBC2XML_NS_URI.equals(uri))
            throw new SAXException("Namspace URI ["+uri+"] is not supported.");

        if (Constants.FOREIGN_KEY_TAG_NAME.equals(localName)) {
            
            this.tableInfo.addForeignKey(new ForeignKeyInfo(atts));
            return null;
        }
        else
            throw new SAXException("foreignkeyset child element ["+localName+"] is not supported.");
    }

}
