/***********************************************************
 * $Id$
 * 
 * JDB to XML bridge of the clazzes project.
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Created: 14.10.2009
 * 
 ***********************************************************/

package org.clazzes.jdbc2xml.sax;

import java.util.ArrayList;
import java.util.List;

/**
 * Configuration for {@link XmlPretty}.
 * 
 * @author rbreuss
 */
public class XmlPrettyConfig {

    private boolean active;
    private int width;
    private int maxDepth;
    private List<String> singleLineTags;

    /**
     * Create a new instance and set <br/>
     * <code>active = true</code><br/>
     * <code>width = 2</code><br/>
     * <code>maxDepth = 8</code>.
     */
    public XmlPrettyConfig()
    {
        this.singleLineTags = new ArrayList<String>();
        this.width = 2;
        this.maxDepth = 8;
        this.active = true;
    }
    
    /**
     * Create a new instance.
     * @param width Indentation.
     * @param maxDepth Maximum depth to indent.
     */
    public XmlPrettyConfig(int width, int maxDepth) {
        this();
        this.width = width;
        this.maxDepth = maxDepth;
    }
    
    /**
     * All data inside the passed tag will be formatted as a single line (without line breaks).
     * @param tagName The tag to omit line breaks for.
     */
    public void addSingleLineTag(String tagName)
    {
        if (!this.singleLineTags.contains(tagName))
            this.singleLineTags.add(tagName);
    }
    /**
     * @return the width
     */
    public int getWidth() {
        return this.width;
    }
    /**
     * @return the maxDepth
     */
    public int getMaxDepth() {
        return this.maxDepth;
    }
    /**
     * @return the singleLineTags
     */
    public List<String> getSingleLineTags() {
        return this.singleLineTags;
    }
    /**
     * @return the active
     */
    public boolean isActive() {
        return this.active;
    }
    /**
     * @param active the active to set
     */
    public void setActive(boolean active) {
        this.active = active;
    }

}
