/***********************************************************
 * $Id$
 * 
 * JDB to XML bridge of the clazzes project.
 * http://www.clazzes.org
 *
 * Created: 27.11.2007
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.jdbc2xml.sax;

import java.io.IOException;
import java.io.Writer;

import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/**
 * This is an adapter class which writes character data to
 * the content of an XML tag using a SAX ContentHandler.
 * 
 * @author wglas
 */
public class SAXCharDataWriter extends Writer {

    private ContentHandler contentHandler;
    
    public SAXCharDataWriter(ContentHandler contentHandler)
    {
        this.contentHandler = contentHandler;
    }
    
    /* (non-Javadoc)
     * @see java.io.Writer#close()
     */
    @Override
    public void close() throws IOException {
    }

    /* (non-Javadoc)
     * @see java.io.Writer#flush()
     */
    @Override
    public void flush() throws IOException {
    }

    /* (non-Javadoc)
     * @see java.io.Writer#write(char[], int, int)
     */
    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        try {
            this.contentHandler.characters(cbuf,off,len);
        } catch (SAXException e) {
            IOException ex = new IOException("SAX error writing character data.");
            ex.initCause(e);
            throw ex;
        }
    }

}
