/***********************************************************
 * $Id$
 *
 * JDB to XML bridge of the clazzes project.
 * http://www.clazzes.org
 *
 * Created: 08.12.2007
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.jdbc2xml.sax;

import javax.xml.XMLConstants;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;

import org.xml.sax.SAXException;

/**
 * This class helps in contructing a Schema instance, which is suitable for
 * parsing jdbc2xml XML documents.
 *
 * @author wglas
 */
public abstract class JDBC2XMLSchemaHelper  {

    /**
     * The resource path, where the jdbc2xml schema description is stored.
     */
    public static final String XML2JDBC_RESOURCE_PATH = "jdbc2xml.xsd";

    /**
     * Construct a schema for the jdbc2xml namespace using the given SchemaFactory
     * and classloader.
     *
     * @param schemaFactory The schema factory to be used, which must be configured to
     *                      parse W3C XML schema descriptions.
     */
    public static Schema createSchema(SchemaFactory schemaFactory) throws SAXException
    {
        return
        schemaFactory.newSchema(new StreamSource(JDBC2XMLSchemaHelper.class.getResourceAsStream(XML2JDBC_RESOURCE_PATH)));
    }

    /**
     * Construct a schema for the jdbc2xml namespace using the SchemaFactory
     * returned by {@link SchemaFactory#newInstance(String)} for the XML w3C
     * schema URI {@link XMLConstants#W3C_XML_SCHEMA_NS_URI}.
     * @throws SAXException in case of sax problems
     */
    public static Schema createSchema() throws SAXException
    {
        return createSchema(SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI));
    }

}
