/***********************************************************
 *
 * JDBC to XML bridge of the clazzes project.
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.jdbc2xml.helper;

import java.util.ServiceLoader;
import java.util.function.Supplier;

public abstract class ServiceHelper {

    /**
     * Load JSDBC2XML service, either from the module layer or from the
     * system class loader.
     * @param <T> The type to load.
     * @param cls The class of the service to load.
     * @return The first resolved service instance.
     */
    public static <T> T loadService(Class<T> cls, Supplier<? extends T> fallback) {

        ModuleLayer layer = cls.getModule().getLayer();

        if (layer == null) {
            return fallback.get();
        }
        else {
            return ServiceLoader.load(layer,cls).findFirst().get();
        }

    }
}
