/***********************************************************
 * $Id$
 * 
 * JDB to XML bridge of the clazzes project.
 * http://www.clazzes.org
 *
 * Created: 02.12.2007
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.jdbc2xml.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * Commonf helper functions, which are not part of JAVA.
 * 
 * @author wglas
 */
public abstract class JAVAHelper {

    /**
     * Simply concatenate a collection of strings by using a comma
     * as separator. No quoting is undertaken, as this function is usually
     * used for SQL column names.
     * 
     * @param sb The string buffer to write the concatenated list of string to.
     * @param strings A collection of strings.
     */
    public static void joinStrings(StringBuffer sb, Collection<String> strings)
    {
        boolean firstItem = true;
        
        for (String s : strings)
        {
            if (firstItem)
                firstItem = false;
            else
                sb.append(',');

            sb.append(s);
        }
    }
    
    /**
     * Simply concatenate a collection of strings by using a comma
     * as separator. No quoting is undertaken, as this function is usually
     * used for SQL column names.
     * 
     * @param strings A collection of strings.
     * @return A string containing all strings delimited by a comma.
     */
    public static String joinStrings(Collection<String> strings)
    {
        StringBuffer sb = new StringBuffer();
        joinStrings(sb,strings);
        return sb.toString();
    }
    
    /**
     * Split a string at all occurrences of the comma char.
     * 
     * @param s The string to split.
     * @return A list of strings.
     */
    public static List<String> splitString(String s)
    {
        int lastPos = 0, pos = 0;
        List<String> ret = new ArrayList<String>();
        
        while ((pos = s.indexOf(',',lastPos)) >= 0)
        {
            ret.add(s.substring(lastPos,pos));
            lastPos = pos+1;
        }
        
        ret.add(s.substring(lastPos));
        
        return ret;
    }
}
