/***********************************************************
 * $Id$
 * 
 * JDB to XML bridge of the clazzes project.
 * http://www.clazzes.org
 *
 * Created: 26.11.2007
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.jdbc2xml.deserialization.impl;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.TimeZone;

import org.clazzes.util.datetime.ISO8601Format;

/**
 * A DeserializationHandler for timestamp values.
 * 
 * @author wglas
 */
public class TimestampDeserializationHandler extends AbstractSbDeserializationHandler {

    private ISO8601Format df;
    
    /**
     * Default constructor.
     * 
     * @param timeZone The timezone to parse date values.
     */
    public TimestampDeserializationHandler(TimeZone timeZone, int type)
    {
        super(type);
        this.df = new ISO8601Format(ISO8601Format.MILLISECOND_FORMAT_NO_TZ,timeZone);
    }
    
    /* (non-Javadoc)
     * @see org.clazzes.jdbc2xml.deserialization.impl.AbstractSbDeserializationHandler#fillColumnValue(java.sql.PreparedStatement, int, java.lang.String)
     */
    @Override
    protected void fillColumnValue(PreparedStatement ps, int column, String value) throws SQLException
    {
        if (value == null)
            ps.setNull(column,this.type);
        else {
            try {
                Calendar c = (Calendar)this.df.parseObject(value);
                ps.setTimestamp(column,new java.sql.Timestamp(c.getTimeInMillis()),c);
     
            } catch (ParseException e) {
                throw new SQLException("XML value ["+value+"] is not a valid ISO8601 string.");
            }
       }
    }
}
