/***********************************************************
 * $Id$
 * 
 * JDB to XML bridge of the clazzes project.
 * http://www.clazzes.org
 *
 * Created: 26.11.2007
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.jdbc2xml.deserialization.impl;

import java.sql.PreparedStatement;
import java.sql.SQLException;

import org.apache.commons.codec.binary.Base64;

/**
 * A DeserializationHandler for binary values like BLOBs or binary string, which are
 * base64-encoded inside XML files.
 * 
 * @author wglas
 */
public class BinaryDeserializationHandler extends AbstractSbDeserializationHandler {

    Base64 decoder;
    
    /**
     * Default constructor.
     */
    public BinaryDeserializationHandler(int type)
    {
        super(type);
        this.decoder = new Base64();
    }
    
    /* (non-Javadoc)
     * @see org.clazzes.jdbc2xml.deserialization.impl.AbstractSbDeserializationHandler#fillColumnValue(java.sql.PreparedStatement, int, java.lang.String)
     */
    @Override
    protected void fillColumnValue(PreparedStatement ps, int column, String value) throws SQLException
    {
        if (value == null)
            ps.setNull(column,this.type);
        else
            ps.setBytes(column,this.decoder.decode(value));
    }
}
