/***********************************************************
 * $Id$
 * 
 * JDB to XML bridge of the clazzes project.
 * http://www.clazzes.org
 *
 * Created: 26.11.2007
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.jdbc2xml.deserialization.impl;

import java.sql.PreparedStatement;
import java.sql.SQLException;

import org.clazzes.jdbc2xml.deserialization.DeserializationHandler;

/**
 * A base class for all DeserializationHandlers, which are setting a String value
 * to a database column.
 * 
 * @author wglas
 */
public abstract class AbstractSbDeserializationHandler implements DeserializationHandler {

    private StringBuffer sb;
    private boolean startCalled;
    protected final int type;

    /**
     * Fill in a column value into the given PreparedStatment.
     * 
     * @param ps The statement to fill.
     * @param column The number of the column to fill.
     * @param value The string value to set or null, if the column has to be nulled.
     * @throws SQLException
     */
    protected abstract void fillColumnValue(PreparedStatement ps, int column,
            String value) throws SQLException;

    /**
     *  Default constructor.
     */
    public AbstractSbDeserializationHandler(int type) {
        super();
        this.startCalled = false;
        this.type = type;
    }

    /* (non-Javadoc)
     * @see org.clazzes.jdbc2xml.deserialization.DeserializationHandler#addCharacters(char[], int, int)
     */
    public void addCharacters(char[] ch, int start, int length) {
        
        this.sb.append(ch,start,length);
    }

    /* (non-Javadoc)
     * @see org.clazzes.jdbc2xml.deserialization.DeserializationHandler#fillColumn(java.sql.PreparedStatement, int)
     */
    public void fillColumn(PreparedStatement ps, int column) throws SQLException {
    
        this.fillColumnValue(ps,column,this.startCalled ? this.sb.toString() : null);
        
        this.startCalled = false;
        
        if (this.sb != null)
            this.sb.delete(0,this.sb.length());
    }

    /* (non-Javadoc)
     * @see org.clazzes.jdbc2xml.deserialization.DeserializationHandler#startCharacters()
     */
    public void startCharacters() {
        
        if (this.sb == null)
            this.sb = new StringBuffer();
        
        this.startCalled = true;
    }

}