/***********************************************************
 * $$Id$$
 * 
 * J2EE-Sandbox classes of the clazzes.org project
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.jdbc2xml.deserialization;

import java.util.TimeZone;

import org.clazzes.jdbc2xml.schema.ColumnInfo;

public interface IDeserializationHandlerFactory {

    /**
     * Return {@link DeserializationHandler} instance for the given column of
     * the result set.
     * 
     * @param ci The column information of the column to be deserialized.
     * @param timeZone The time zone used to parse date values, if the database provides
     *                 no time zone information.
     * @return A suitable deserialization handler.
     */
    abstract public DeserializationHandler newDeserializationHandler(
            ColumnInfo ci, TimeZone timeZone);

}
