/***********************************************************
 * $Id$
 *
 * JDB to XML bridge of the clazzes project.
 * http://www.clazzes.org
 *
 * Created: 26.11.2007
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.jdbc2xml.deserialization;

import org.clazzes.jdbc2xml.deserialization.impl.DeserializationHandlerFactoryImpl;
import org.clazzes.jdbc2xml.helper.ServiceHelper;

/**
 * Implementations of this factory instantiate {@link DeserializationHandler}
 * instances for a given column of a XML rowset tag.
 *
 * @author wglas
 */
public abstract class DeserializationHandlerFactory implements IDeserializationHandlerFactory {

    /**
     * @return The first implementation registered under the resource path
     * <code>META-INF/services/org.clazzes.jdbc2xml.deserialization.DeserializationHandlerFactory</code>.
     */
    static public IDeserializationHandlerFactory newInstance()
    {
        return ServiceHelper.loadService(DeserializationHandlerFactory.class,DeserializationHandlerFactoryImpl::new);
    }

}
