/***********************************************************
 * $Id$
 * 
 * JDB to XML bridge of the clazzes project.
 * http://www.clazzes.org
 *
 * Created: 26.11.2007
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.jdbc2xml.deserialization;

import java.sql.PreparedStatement;
import java.sql.SQLException;

import org.xml.sax.ContentHandler;

/**
 * A DeserializationHandler instance handles the deserialization
 * of the CDATA of content of a tag to a database column.
 * 
 * @author wglas
 */
public interface DeserializationHandler {

    /**
     * Start receiving data. This is called as part of
     * an {@link ContentHandler#startElement(String, String, String, org.xml.sax.Attributes)}
     * operation.
     */
    void startCharacters();
    
    /**
     * Push characters received by {@link ContentHandler#characters(char[], int, int)}
     * to the field content.
     * 
     * This method throws an exception, {@link #startCharacters()} has not been called before.
     * 
     * @param ch The character array.
     * @param start The start index of the data to push.
     * @param length The length of the data to push.
     */
    void addCharacters(char [] ch, int start, int length);
 
    /**
     * Fill the column of the given prepared statement with the data received so far.
     * If no data has been received, i.e. {@link #startCharacters()} has not been called
     * before, set the column to an SQL null value.
     * 
     * This call resets the state of this handler, so {@link #startCharacters()} may be called
     * again.
     * 
     * @param ps The PreparedStatement to fill.
     * @param column The number of the column to set.
     * @throws SQLException 
     */ 
    void fillColumn(PreparedStatement ps, int column) throws SQLException;
}
