import org.clazzes.jdbc2xml.deserialization.DeserializationHandlerFactory;
import org.clazzes.jdbc2xml.deserialization.IDeserializationHandlerFactory;
import org.clazzes.jdbc2xml.deserialization.impl.DeserializationHandlerFactoryImpl;
import org.clazzes.jdbc2xml.schema.DialectFactory;
import org.clazzes.jdbc2xml.schema.IDialectFactory;
import org.clazzes.jdbc2xml.schema.ISchemaEngine;
import org.clazzes.jdbc2xml.schema.ISchemaEngineFactory;
import org.clazzes.jdbc2xml.schema.SchemaEngine;
import org.clazzes.jdbc2xml.schema.impl.DialectFactoryImpl;
import org.clazzes.jdbc2xml.schema.impl.SchemaEngineFactoryImpl;
import org.clazzes.jdbc2xml.schema.impl.SchemaEngineImpl;
import org.clazzes.jdbc2xml.serialization.ISerializationHandlerFactory;
import org.clazzes.jdbc2xml.serialization.SerializationHandlerFactory;
import org.clazzes.jdbc2xml.serialization.impl.SerializationHandlerFactoryImpl;
import org.clazzes.jdbc2xml.sql.ISqlIdentifierMapperFactory;
import org.clazzes.jdbc2xml.sql.SqlIdentifierMapperFactory;
import org.clazzes.jdbc2xml.sql.impl.SqlIdentifierMapperFactoryImpl;

module org.clazzes.jdbc2xml {
    exports org.clazzes.jdbc2xml.deserialization;
    exports org.clazzes.jdbc2xml.deserialization.impl;
    exports org.clazzes.jdbc2xml.helper;
    exports org.clazzes.jdbc2xml.sax;
    exports org.clazzes.jdbc2xml.sax.impl;
    exports org.clazzes.jdbc2xml.schema;
    exports org.clazzes.jdbc2xml.schema.impl;
    exports org.clazzes.jdbc2xml.serialization;
    exports org.clazzes.jdbc2xml.serialization.impl;
    exports org.clazzes.jdbc2xml.sql;
    exports org.clazzes.jdbc2xml.sql.impl;
    exports org.clazzes.jdbc2xml.tools;
    exports org.clazzes.jdbc2xml;

    requires java.sql;
    requires org.clazzes.util.base;
    requires org.clazzes.svc.api;
    requires org.apache.commons.codec;
    requires org.apache.commons.compress;
    requires org.slf4j;

    provides ISchemaEngineFactory with SchemaEngineFactoryImpl;

    provides ISchemaEngine with SchemaEngineImpl;
    provides SchemaEngine with SchemaEngineImpl;
    uses SchemaEngine;

    provides IDialectFactory with DialectFactoryImpl;
    provides DialectFactory with DialectFactoryImpl;
    uses DialectFactory;

    provides ISerializationHandlerFactory with SerializationHandlerFactoryImpl;
    provides SerializationHandlerFactory with SerializationHandlerFactoryImpl;
    uses SerializationHandlerFactory;

    provides IDeserializationHandlerFactory with DeserializationHandlerFactoryImpl;
    provides DeserializationHandlerFactory with DeserializationHandlerFactoryImpl;
    uses DeserializationHandlerFactory;

    provides ISqlIdentifierMapperFactory with SqlIdentifierMapperFactoryImpl;
    provides SqlIdentifierMapperFactory with SqlIdentifierMapperFactoryImpl;
    uses SqlIdentifierMapperFactory;
}
