/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.tools;

import java.lang.invoke.CallSite;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.clazzes.jdbc2xml.schema.ColumnInfo;
import org.clazzes.jdbc2xml.schema.ForeignKeyInfo;
import org.clazzes.jdbc2xml.schema.ISchemaEngine;
import org.clazzes.jdbc2xml.schema.SortableTableDescription;
import org.clazzes.jdbc2xml.schema.TableInfo;
import org.clazzes.jdbc2xml.schema.TableSorter;
import org.clazzes.jdbc2xml.tools.ProcessRestrictionFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBDataExtractor {
    private static final Logger log = LoggerFactory.getLogger(DBDataExtractor.class);
    private ISchemaEngine schemaEngine;
    private ProcessRestrictionFilter processRestrictionFilter;
    private String exportDbName;
    private Hashtable<String, SortableTableDescription> tablesToExport;

    public void extract() throws SQLException {
        if (this.schemaEngine == null) {
            log.error("schemaEngine is null.");
            return;
        }
        if (this.processRestrictionFilter == null) {
            log.error("processRestrictionFilter is null.");
            return;
        }
        if (this.exportDbName.equals(this.schemaEngine.getConnection().getCatalog())) {
            throw new SQLException("The export database must be different from the originating catalog.");
        }
        log.info("begin fetching requested TableInfo's from source database ...");
        List<TableInfo> tableInfos = this.schemaEngine.fetchTableInfos(this.processRestrictionFilter);
        log.info("fetching TableInfo's from source database done.");
        String oldCatalog = this.schemaEngine.getConnection().getCatalog();
        this.schemaEngine.getConnection().setCatalog(this.exportDbName);
        List<TableInfo> tempTableInfos = this.schemaEngine.fetchTableInfos(this.processRestrictionFilter);
        if (tempTableInfos != null && tempTableInfos.size() > 0) {
            log.info("Dropping [" + tempTableInfos.size() + "] old tables in destination database ...");
            this.schemaEngine.dropTables(tempTableInfos, true);
            this.schemaEngine.commit();
            log.info("Finished dropping [" + tempTableInfos.size() + "] old tables in destination database.");
        }
        log.info("Creating table structure in destination database ...");
        for (TableInfo ti : tableInfos) {
            this.schemaEngine.createTable(ti, false);
        }
        this.schemaEngine.commit();
        log.info("Finished creating table structure in destination database.");
        this.schemaEngine.getConnection().setCatalog(oldCatalog);
        ArrayList<SortableTableDescription> tableDescs = new ArrayList<SortableTableDescription>();
        for (TableInfo ti : tableInfos) {
            tableDescs.add(new SortableTableDescription(ti));
        }
        TableSorter.sortTablesByFKDepth(tableDescs);
        this.tablesToExport = new Hashtable(tableDescs.size());
        for (SortableTableDescription std : tableDescs) {
            this.tablesToExport.put(std.getTableInfo().getName(), std);
        }
        log.info("begin export to temporary database ...");
        for (SortableTableDescription std : tableDescs) {
            this.exportTableByForeignKeys(std, null);
        }
        log.info("export to temporary database done.");
        log.info("begin foreign key creation for temporary database ...");
        for (TableInfo ti : tableInfos) {
            String tableName = ti.getName();
            ti.setName(this.exportDbName + "." + tableName);
            this.schemaEngine.createForeignKeys(ti);
            ti.setName(tableName);
        }
        log.info("foreign key creation for temporary database done.");
    }

    private boolean omitForeignKey(ForeignKeyInfo fki, SortableTableDescription std, SortableTableDescription referencingTable) {
        if (fki == null) {
            return true;
        }
        if (fki.getForeignTable().equalsIgnoreCase(std.getTableInfo().getName())) {
            return true;
        }
        if (referencingTable != null && referencingTable.getTableInfo().getName().equalsIgnoreCase(fki.getForeignTable())) {
            return true;
        }
        return !this.processRestrictionFilter.processTable(fki.getForeignTable());
    }

    private void exportTableByForeignKeys(SortableTableDescription std, SortableTableDescription referencingTable) throws SQLException {
        if (std == null || std.getTableInfo() == null) {
            return;
        }
        if (this.tablesToExport.get(std.getTableInfo().getName()) == null) {
            return;
        }
        List<ForeignKeyInfo> fkis = std.getTableInfo().getForeignKeys();
        if (fkis != null && fkis.size() > 0) {
            for (ForeignKeyInfo fki : fkis) {
                SortableTableDescription fkTable;
                if (this.omitForeignKey(fki, std, referencingTable) || (fkTable = this.tablesToExport.get(fki.getForeignTable())) == null) continue;
                log.info("try to export [" + std.getTableInfo().getName() + "], has to export [" + fki.getForeignTable() + "] first.");
                this.exportTableByForeignKeys(fkTable, std);
                this.exportTableByForeignKeys(std, null);
                return;
            }
        }
        TableInfo ti = std.getTableInfo();
        Map<String, String> restrictions = this.processRestrictionFilter.getPrimaryRestrictions();
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(this.exportDbName);
        sql.append(".");
        sql.append(ti.getName());
        sql.append(" SELECT DISTINCT ");
        StringBuffer joinExpr = new StringBuffer();
        joinExpr.append(" FROM ");
        joinExpr.append(ti.getName());
        joinExpr.append(" t1");
        int t = 2;
        if (fkis != null && fkis.size() > 0) {
            for (ForeignKeyInfo fki : fkis) {
                if (this.omitForeignKey(fki, std, referencingTable)) continue;
                joinExpr.append(" LEFT JOIN ");
                joinExpr.append(this.exportDbName);
                joinExpr.append(".");
                joinExpr.append(fki.getForeignTable());
                joinExpr.append(" t");
                joinExpr.append(t);
                joinExpr.append(" ON (");
                int i = 0;
                for (String col : fki.getColumns()) {
                    if (i > 0) {
                        joinExpr.append(" AND ");
                    }
                    joinExpr.append("t1.");
                    joinExpr.append(col);
                    joinExpr.append(" = t");
                    joinExpr.append(t);
                    joinExpr.append(".");
                    joinExpr.append(fki.getForeignColumns().get(i++));
                }
                joinExpr.append(")");
                ++t;
            }
        }
        boolean hasWhere = false;
        HashMap<String, CallSite> nullRestrictions = null;
        if (restrictions != null && restrictions.containsKey(ti.getName())) {
            String restrictionValue = restrictions.get(ti.getName());
            if (restrictionValue == null) {
                nullRestrictions = new HashMap<String, CallSite>();
            } else {
                log.info("restrcict table [" + ti.getName() + "] to id=[" + restrictionValue + "].");
                joinExpr.append(" WHERE t1.id=");
                joinExpr.append(restrictionValue);
                hasWhere = true;
            }
        }
        if (fkis != null && fkis.size() > 0) {
            t = 2;
            for (ForeignKeyInfo foreignKeyInfo : fkis) {
                if (this.omitForeignKey(foreignKeyInfo, std, referencingTable)) continue;
                boolean nullableFK = this.isFKNullable(ti, foreignKeyInfo);
                if (nullRestrictions != null && nullableFK) {
                    for (i = 0; i < foreignKeyInfo.getColumns().size(); ++i) {
                        col = foreignKeyInfo.getColumns().get(i);
                        foreignCol = foreignKeyInfo.getForeignColumns().get(i);
                        nullRestrictions.put(col, (CallSite)((Object)("t" + t + "." + foreignCol)));
                    }
                } else {
                    for (i = 0; i < foreignKeyInfo.getColumns().size(); ++i) {
                        col = foreignKeyInfo.getColumns().get(i);
                        foreignCol = foreignKeyInfo.getForeignColumns().get(i);
                        if (hasWhere) {
                            joinExpr.append(" AND ");
                        } else if (t == 2 && i == 0) {
                            joinExpr.append(" WHERE ");
                            hasWhere = true;
                        }
                        if (nullableFK) {
                            joinExpr.append("(t1.");
                            joinExpr.append(col);
                            joinExpr.append(" IS NULL OR ");
                        }
                        joinExpr.append("t");
                        joinExpr.append(t);
                        joinExpr.append(".");
                        joinExpr.append(foreignCol);
                        joinExpr.append(" IS NOT NULL");
                        if (!nullableFK) continue;
                        joinExpr.append(")");
                    }
                }
                ++t;
            }
        }
        boolean firstColumn = true;
        for (ColumnInfo ci : ti.getColumns()) {
            String replacement;
            if (firstColumn) {
                firstColumn = false;
            } else {
                sql.append(", ");
            }
            String string = replacement = nullRestrictions == null ? null : (String)nullRestrictions.get(ci.getName());
            if (replacement != null) {
                sql.append(replacement);
                continue;
            }
            sql.append("t1.");
            sql.append(ci.getName());
        }
        sql.append(joinExpr);
        log.info("start executing: " + sql.toString());
        try (Statement statement = this.schemaEngine.getConnection().createStatement();){
            statement.execute(sql.toString());
        }
        this.tablesToExport.remove(ti.getName());
        log.info("execution ok, [" + this.tablesToExport.size() + "] tables remaining.");
    }

    private boolean isFKNullable(TableInfo ti, ForeignKeyInfo fki) {
        for (String columnName : fki.getColumns()) {
            ColumnInfo ci = ti.getColumnInfo(columnName);
            if (ci != null && ci.isNullable()) continue;
            return false;
        }
        return true;
    }

    public void setSchemaEngine(ISchemaEngine schemaEngine) {
        this.schemaEngine = schemaEngine;
    }

    public void setProcessRestrictionFilter(ProcessRestrictionFilter processRestrictionFilter) {
        this.processRestrictionFilter = processRestrictionFilter;
    }

    public void setExportDbName(String exportDbName) {
        this.exportDbName = exportDbName;
    }
}

