/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Stack;
import org.clazzes.jdbc2xml.sql.QuerieSqlCommand;
import org.clazzes.jdbc2xml.sql.SimpleSqlCommand;
import org.clazzes.jdbc2xml.sql.SqlCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlCommandQueue {
    private static final Logger log = LoggerFactory.getLogger(SqlCommandQueue.class);
    private final Stack<SqlCommand> commands = new Stack();
    private int watermark = 0;

    public void pushCommand(SqlCommand command) {
        this.commands.push(command);
    }

    public void pushCommand(String performSql, String rollbackSql) {
        this.commands.push(new SimpleSqlCommand(performSql, rollbackSql));
    }

    public void pushQuerieCommand(String performSql, String rollbackSql) {
        this.commands.push(new QuerieSqlCommand(performSql, rollbackSql));
    }

    public void perform(Connection connection) throws SQLException {
        while (this.watermark < this.commands.size()) {
            SqlCommand command = null;
            try {
                command = (SqlCommand)this.commands.get(this.watermark);
                command.perform(connection);
            }
            catch (Exception e) {
                String reason = "perform: Caught [" + e.getClass().getSimpleName() + "] performing command [" + command.toString() + "].";
                log.error(reason, (Throwable)e);
                throw new SQLException(reason, e);
            }
            ++this.watermark;
        }
    }

    public void commit(Connection connection) throws SQLException {
        this.perform(connection);
        for (SqlCommand cmd : this.commands) {
            cmd.cleanupOnCommit(connection);
        }
        this.commands.clear();
        this.watermark = 0;
    }

    public void rollback(Connection connection) throws SQLException {
        while (this.watermark > 0) {
            --this.watermark;
            SqlCommand command = null;
            try {
                command = (SqlCommand)this.commands.get(this.watermark);
                command.rollback(connection);
            }
            catch (Exception e) {
                String reason = "rollback: Caught [" + e.getClass().getSimpleName() + "] performing command [" + command.toString() + "].";
                log.error(reason);
                throw new SQLException(reason, e);
            }
        }
        this.commands.clear();
        this.watermark = 0;
    }

    public Enumeration<SqlCommand> commands() {
        return this.commands.elements();
    }
}

