/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.sql;

import java.sql.Connection;
import java.sql.SQLException;
import org.clazzes.jdbc2xml.helper.SQLHelper;
import org.clazzes.jdbc2xml.sql.SqlCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuerieSqlCommand
implements SqlCommand {
    private static final Logger log = LoggerFactory.getLogger(QuerieSqlCommand.class);
    private String performSql;
    private String rollbackSql;

    public QuerieSqlCommand(String performSql, String rollbackSql) {
        this.performSql = performSql;
        this.rollbackSql = rollbackSql;
    }

    @Override
    public void perform(Connection connection) throws SQLException {
        if (this.performSql == null) {
            throw new SQLException("This statement has already been committed.");
        }
        if (log.isDebugEnabled()) {
            log.debug("Performing statement [" + this.performSql + "].");
        }
        try {
            SQLHelper.executeQuerie(connection, this.performSql);
        }
        catch (SQLException e) {
            log.error("SQL [" + this.performSql + "] threw an Exception: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void rollback(Connection connection) throws SQLException {
        if (this.rollbackSql == null) {
            throw new SQLException("Rollback of statement [" + this.performSql + "] is not supported.");
        }
        if (log.isDebugEnabled()) {
            log.debug("Executing rollback statement [" + this.rollbackSql + "].");
        }
        SQLHelper.executeUpdate(connection, this.rollbackSql);
    }

    public String getPerformSql() {
        return this.performSql;
    }

    public String getRollbackSql() {
        return this.rollbackSql;
    }

    @Override
    public void cleanupOnCommit(Connection connection) throws SQLException {
        this.performSql = null;
        this.rollbackSql = null;
    }

    @Override
    public String getTempTableName() {
        return null;
    }

    @Override
    public boolean isTempTableCreated() {
        return false;
    }
}

