/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.serialization.impl;

import java.util.TimeZone;
import org.clazzes.jdbc2xml.schema.ColumnInfo;
import org.clazzes.jdbc2xml.serialization.SerializationHandler;
import org.clazzes.jdbc2xml.serialization.SerializationHandlerFactory;
import org.clazzes.jdbc2xml.serialization.impl.BigDecimalSerializationHandler;
import org.clazzes.jdbc2xml.serialization.impl.BinarySerializationHandler;
import org.clazzes.jdbc2xml.serialization.impl.BooleanSerializationHandler;
import org.clazzes.jdbc2xml.serialization.impl.DateSerializationHandler;
import org.clazzes.jdbc2xml.serialization.impl.DoubleSerializationHandler;
import org.clazzes.jdbc2xml.serialization.impl.FloatSerializationHandler;
import org.clazzes.jdbc2xml.serialization.impl.IntegerSerializationHandler;
import org.clazzes.jdbc2xml.serialization.impl.StringSerializationHandler;
import org.clazzes.jdbc2xml.serialization.impl.TimestampSerializationHandler;

public class SerializationHandlerFactoryImpl
extends SerializationHandlerFactory {
    @Override
    public SerializationHandler newSerializationHandler(ColumnInfo ci, TimeZone timeZone) {
        switch (ci.getType()) {
            case -6: 
            case 4: 
            case 5: {
                return new IntegerSerializationHandler();
            }
            case 8: {
                return new DoubleSerializationHandler();
            }
            case 6: {
                return new FloatSerializationHandler();
            }
            case -5: 
            case 2: 
            case 3: 
            case 7: {
                return new BigDecimalSerializationHandler();
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2001: 
            case 2005: 
            case 2011: {
                return new StringSerializationHandler();
            }
            case 91: {
                return new DateSerializationHandler(timeZone);
            }
            case 93: 
            case 2014: {
                return new TimestampSerializationHandler(timeZone);
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return new BinarySerializationHandler();
            }
            case -7: 
            case 16: {
                return new BooleanSerializationHandler();
            }
        }
        return null;
    }
}

