/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.serialization.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.clazzes.jdbc2xml.serialization.SerializationHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class BooleanSerializationHandler
implements SerializationHandler {
    private Boolean value = false;
    private boolean _null = true;

    @Override
    public void fetchData(ResultSet rs, int column) throws SQLException {
        this.value = rs.getBoolean(column);
        this._null = rs.wasNull();
    }

    @Override
    public boolean isNull() {
        return this._null;
    }

    @Override
    public void pushData(ContentHandler handler) throws SAXException {
        String s = Boolean.toString(this.value);
        handler.characters(s.toCharArray(), 0, s.length());
    }
}

