/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.schema.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import org.clazzes.jdbc2xml.helper.JAVAHelper;
import org.clazzes.jdbc2xml.helper.SQLHelper;
import org.clazzes.jdbc2xml.helper.TypesHelper;
import org.clazzes.jdbc2xml.schema.ColumnInfo;
import org.clazzes.jdbc2xml.schema.ForeignKeyInfo;
import org.clazzes.jdbc2xml.schema.IDialectFactory;
import org.clazzes.jdbc2xml.schema.IndexFilter;
import org.clazzes.jdbc2xml.schema.IndexInfo;
import org.clazzes.jdbc2xml.schema.PrimaryKeyInfo;
import org.clazzes.jdbc2xml.schema.SchemaEngine;
import org.clazzes.jdbc2xml.schema.TableFilter;
import org.clazzes.jdbc2xml.schema.TableInfo;
import org.clazzes.jdbc2xml.schema.impl.DDLHelper;
import org.clazzes.jdbc2xml.schema.impl.MSSQLServerDialect;
import org.clazzes.jdbc2xml.schema.impl.OracleDialect;
import org.clazzes.jdbc2xml.sql.SqlCommand;
import org.clazzes.jdbc2xml.sql.SqlCommandQueue;
import org.clazzes.util.lang.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaEngineImpl
extends SchemaEngine {
    private static final Logger log = LoggerFactory.getLogger(SchemaEngineImpl.class);
    private final SqlCommandQueue queue = new SqlCommandQueue();
    private int maxTableNameLength;

    public SchemaEngineImpl() {
    }

    public SchemaEngineImpl(IDialectFactory dialectFactory) {
        super(dialectFactory);
    }

    @Override
    public void setConnection(Connection connection) throws SQLException {
        super.setConnection(connection);
        if (this.getConnection() != null) {
            DatabaseMetaData dbMeta = this.getConnection().getMetaData();
            this.maxTableNameLength = dbMeta.getMaxTableNameLength();
        }
    }

    private void addColumnsToTableInfo(DatabaseMetaData dbMeta, TableInfo ti, boolean doCheckForAutoIncrement) throws SQLException {
        try (ResultSet rs = dbMeta.getColumns(this.getConnection().getCatalog(), this.toStoredIdentifier(dbMeta, this.getSchema()), this.toStoredIdentifier(dbMeta, ti.getName()), null);){
            while (rs.next()) {
                int nullable_i;
                Integer scale;
                Integer precision;
                String name = rs.getString("COLUMN_NAME");
                int type = rs.getInt("DATA_TYPE");
                String typeName = rs.getString("TYPE_NAME");
                log.info("addColumnsToTableInfo: Column [" + name + "] type=[" + type + "] -> [" + rs.getString("TYPE_NAME") + "].");
                if (type == -7 && "bool".equals(typeName)) {
                    type = 16;
                }
                if (type == 1111 || type == 93 || type == 2014 || type == -101 || type == -155) {
                    type = this.getDialect().getMappedSqlType(typeName);
                    log.debug("Got mapping [" + type + "] for typeName [" + typeName + "]");
                }
                int prec_i = rs.getInt("COLUMN_SIZE");
                Integer n = precision = rs.wasNull() ? null : Integer.valueOf(prec_i);
                if (type == 2 || type == 3 || type == 7) {
                    int scale_i = rs.getInt("DECIMAL_DIGITS");
                    scale = rs.wasNull() ? null : Integer.valueOf(scale_i);
                } else {
                    scale = null;
                }
                if (type == 2 && precision != null && precision > 65535) {
                    precision = null;
                    scale = null;
                }
                if ((type == 2 || type == 3) && scale != null && scale < 0) {
                    precision = null;
                    scale = null;
                }
                if (type == -2 && precision != null && precision >= Integer.MAX_VALUE) {
                    type = -4;
                    precision = null;
                }
                boolean nullable = (nullable_i = rs.getInt("NULLABLE")) != 0;
                boolean autoIncrement = false;
                String defaultValue = null;
                if (doCheckForAutoIncrement && this.getDialect() instanceof MSSQLServerDialect && typeName.contains(" identity")) {
                    autoIncrement = true;
                }
                if (TypesHelper.isNumeric(type)) {
                    String def = rs.getString("COLUMN_DEF");
                    if (this.getDialect() != null) {
                        def = this.getDialect().normalizeDefaultValue(type, def);
                    }
                    if (def != null && def.length() > 0) {
                        defaultValue = def;
                    }
                } else if (TypesHelper.isString(type)) {
                    defaultValue = rs.getString("COLUMN_DEF");
                    if (precision != null && precision >= Integer.MAX_VALUE) {
                        type = -1;
                        precision = null;
                    }
                    if (this.getDialect() != null) {
                        defaultValue = this.getDialect().normalizeDefaultValue(type, defaultValue);
                    }
                }
                ColumnInfo ci = new ColumnInfo(name, type, precision, scale, nullable, defaultValue, autoIncrement);
                ti.addColumn(ci);
            }
        }
    }

    private void checkAutoIncrementColumn(TableInfo ti) throws SQLException {
        String autoIncrementColumn = null;
        try (ResultSet rs = null;){
            Statement st = this.getConnection().createStatement();
            st.setMaxRows(1);
            if (st.execute("SELECT * FROM " + (String)(this.getSchema() == null ? ti.getName() : this.getSchema() + "." + ti.getName()))) {
                ColumnInfo ci;
                rs = st.getResultSet();
                ResultSetMetaData md = rs.getMetaData();
                int cols = md.getColumnCount();
                for (int col = 1; col < cols; ++col) {
                    if (!md.isAutoIncrement(col)) continue;
                    autoIncrementColumn = md.getColumnName(col);
                    break;
                }
                if (autoIncrementColumn != null && (ci = ti.getColumnInfo(autoIncrementColumn)) != null) {
                    ci.setAutoIncrement(true);
                }
            }
        }
    }

    private void addPrimaryKeyToTableInfo(DatabaseMetaData dbMeta, TableInfo ti) throws SQLException {
        try (ResultSet rs = dbMeta.getPrimaryKeys(this.getConnection().getCatalog(), this.toStoredIdentifier(dbMeta, this.getSchema()), this.toStoredIdentifier(dbMeta, ti.getName()));){
            if (!rs.next()) {
                return;
            }
            String tableName = rs.getString("TABLE_NAME");
            String tableCat = rs.getString("TABLE_CAT");
            String tableSchema = rs.getString("TABLE_SCHEM");
            Integer seq = Integer.parseInt(rs.getString("KEY_SEQ"));
            String name = rs.getString("PK_NAME");
            TreeMap<Integer, String> sortedColumns = new TreeMap<Integer, String>();
            sortedColumns.put(seq, rs.getString("COLUMN_NAME"));
            while (rs.next() && Util.equalsNullAware((Object)tableName, (Object)rs.getString("TABLE_NAME")) && Util.equalsNullAware((Object)tableCat, (Object)rs.getString("TABLE_CAT")) && Util.equalsNullAware((Object)tableSchema, (Object)rs.getString("TABLE_SCHEM")) && Util.equalsNullAware((Object)name, (Object)rs.getString("PK_NAME"))) {
                seq = Integer.parseInt(rs.getString("KEY_SEQ"));
                sortedColumns.put(seq, rs.getString("COLUMN_NAME"));
            }
            if ("PRIMARY".equals(name)) {
                name = null;
            }
            ArrayList<String> columns = new ArrayList<String>(sortedColumns.size());
            columns.addAll(sortedColumns.values());
            PrimaryKeyInfo pki = new PrimaryKeyInfo();
            pki.setName(name);
            pki.setColumns(columns);
            ti.setPrimaryKey(pki);
        }
    }

    private void addIndicesToTableInfo(DatabaseMetaData dbMeta, TableInfo ti, boolean keepInternalIndices) throws SQLException {
        try (ResultSet rs = dbMeta.getIndexInfo(this.getConnection().getCatalog(), this.toStoredIdentifier(dbMeta, this.getSchema()), this.toStoredIdentifier(dbMeta, ti.getName()), false, false);){
            boolean hasNext = rs.next();
            while (hasNext) {
                String tableName = rs.getString("TABLE_NAME");
                String tableCat = rs.getString("TABLE_CAT");
                String tableSchema = rs.getString("TABLE_SCHEM");
                if (rs.getShort("TYPE") == 0) {
                    hasNext = rs.next();
                    continue;
                }
                String order_s = rs.getString("ASC_OR_DESC");
                IndexInfo.Order order = order_s == null ? null : (order_s.startsWith("D") ? IndexInfo.Order.DESC : IndexInfo.Order.ASC);
                boolean unique = !rs.getBoolean("NON_UNIQUE");
                String filterCondition = rs.getString("FILTER_CONDITION");
                Integer seq = Integer.parseInt(rs.getString("ORDINAL_POSITION"));
                String name = rs.getString("INDEX_NAME");
                TreeMap<Integer, String> sortedColumns = new TreeMap<Integer, String>();
                sortedColumns.put(seq, rs.getString("COLUMN_NAME"));
                while ((hasNext = rs.next()) && Util.equalsNullAware((Object)tableName, (Object)rs.getString("TABLE_NAME")) && Util.equalsNullAware((Object)tableCat, (Object)rs.getString("TABLE_CAT")) && Util.equalsNullAware((Object)tableSchema, (Object)rs.getString("TABLE_SCHEM")) && Util.equalsNullAware((Object)name, (Object)rs.getString("INDEX_NAME"))) {
                    seq = Integer.parseInt(rs.getString("ORDINAL_POSITION"));
                    sortedColumns.put(seq, rs.getString("COLUMN_NAME"));
                }
                ArrayList<String> columns = new ArrayList<String>(sortedColumns.size());
                columns.addAll(sortedColumns.values());
                boolean doInsert = true;
                if (!keepInternalIndices) {
                    if (ti.getPrimaryKey() != null && ti.getPrimaryKey().getColumns().equals(columns)) {
                        if (log.isDebugEnabled()) {
                            log.debug("Skipping internal index [" + name + "] because it covers the primary key columns [" + JAVAHelper.joinStrings(ti.getPrimaryKey().getColumns()) + "].");
                        }
                        doInsert = false;
                    }
                    if (doInsert && ti.getForeignKeys() != null) {
                        for (ForeignKeyInfo fkInfo : ti.getForeignKeys()) {
                            if (!fkInfo.getColumns().equals(columns)) continue;
                            if (log.isDebugEnabled()) {
                                log.debug("Skipping internal index [" + name + "] because it covers the columns [" + JAVAHelper.joinStrings(fkInfo.getColumns()) + "] of foreign key [" + fkInfo.getName() + "].");
                            }
                            doInsert = false;
                            break;
                        }
                    }
                }
                if (!doInsert) continue;
                IndexInfo ii = new IndexInfo();
                ii.setName(name);
                ii.setColumns(columns);
                ii.setUnique(unique);
                ii.setFilterCondition(filterCondition);
                ii.setOrder(order);
                ti.addIndex(ii);
            }
        }
    }

    private void addForeignKeysToTableInfo(DatabaseMetaData dbMeta, TableInfo ti) throws SQLException {
        try (ResultSet rs = dbMeta.getImportedKeys(this.getConnection().getCatalog(), this.toStoredIdentifier(dbMeta, this.getSchema()), this.toStoredIdentifier(dbMeta, ti.getName()));){
            boolean hasNext = rs.next();
            while (hasNext) {
                short deleteRule;
                String tableName = rs.getString("FKTABLE_NAME");
                String tableCat = rs.getString("FKTABLE_CAT");
                String tableSchema = rs.getString("FKTABLE_SCHEM");
                if (!Util.equalsNullAware((Object)tableCat, (Object)rs.getString("PKTABLE_CAT")) || !Util.equalsNullAware((Object)tableSchema, (Object)rs.getString("PKTABLE_SCHEM"))) {
                    hasNext = rs.next();
                    continue;
                }
                String foreignTable = rs.getString("PKTABLE_NAME");
                Integer seq = Integer.parseInt(rs.getString("KEY_SEQ"));
                String name = rs.getString("FK_NAME");
                String pkName = rs.getString("PK_NAME");
                short updateRule = rs.getShort("UPDATE_RULE");
                if (updateRule == 1) {
                    updateRule = 3;
                }
                if ((deleteRule = rs.getShort("DELETE_RULE")) == 1) {
                    deleteRule = 3;
                }
                short deferrability = rs.getShort("DEFERRABILITY");
                TreeMap<Integer, String> sortedColumns = new TreeMap<Integer, String>();
                TreeMap<Integer, String> sortedForeignColumns = new TreeMap<Integer, String>();
                sortedColumns.put(seq, rs.getString("FKCOLUMN_NAME"));
                sortedForeignColumns.put(seq, rs.getString("PKCOLUMN_NAME"));
                while ((hasNext = rs.next()) && Util.equalsNullAware((Object)tableName, (Object)rs.getString("FKTABLE_NAME")) && Util.equalsNullAware((Object)foreignTable, (Object)rs.getString("PKTABLE_NAME")) && Util.equalsNullAware((Object)tableCat, (Object)rs.getString("FKTABLE_CAT")) && Util.equalsNullAware((Object)tableCat, (Object)rs.getString("PKTABLE_CAT")) && Util.equalsNullAware((Object)tableSchema, (Object)rs.getString("FKTABLE_SCHEM")) && Util.equalsNullAware((Object)tableSchema, (Object)rs.getString("PKTABLE_SCHEM")) && Util.equalsNullAware((Object)name, (Object)rs.getString("FK_NAME")) && Util.equalsNullAware((Object)pkName, (Object)rs.getString("PK_NAME"))) {
                    seq = Integer.parseInt(rs.getString("KEY_SEQ"));
                    sortedColumns.put(seq, rs.getString("FKCOLUMN_NAME"));
                    sortedForeignColumns.put(seq, rs.getString("PKCOLUMN_NAME"));
                }
                ArrayList<String> columns = new ArrayList<String>(sortedColumns.size());
                columns.addAll(sortedColumns.values());
                ArrayList<String> foreignColumns = new ArrayList<String>(sortedForeignColumns.size());
                foreignColumns.addAll(sortedForeignColumns.values());
                ForeignKeyInfo fki = new ForeignKeyInfo();
                fki.setName(name);
                fki.setForeignTable(foreignTable);
                fki.setPkName(pkName);
                fki.setColumns(columns);
                fki.setForeignColumns(foreignColumns);
                fki.setDeleteRule(deleteRule);
                fki.setUpdateRule(updateRule);
                fki.setDeferrability(deferrability);
                ti.addForeignKey(fki);
            }
        }
    }

    private String toStoredIdentifier(DatabaseMetaData dbMeta, String id) throws SQLException {
        if (id == null) {
            return null;
        }
        if (dbMeta.storesLowerCaseIdentifiers()) {
            return id.toLowerCase(Locale.ENGLISH);
        }
        if (dbMeta.storesUpperCaseIdentifiers()) {
            return id.toUpperCase(Locale.ENGLISH);
        }
        return id;
    }

    @Override
    public TableInfo fetchTableInfo(String tableName, IndexFilter filter) throws SQLException {
        DatabaseMetaData dbMeta = this.getConnection().getMetaData();
        this.maxTableNameLength = dbMeta.getMaxTableNameLength();
        log.info("fetch table info [" + dbMeta.getDatabaseProductName() + ", version: " + dbMeta.getDatabaseProductVersion() + "], table=[" + tableName + "].");
        boolean doCheckForAutoIncrementColumns = SchemaEngineImpl.isDoCheckAutoIncrementColumns(filter);
        try (ResultSet rs = dbMeta.getTables(this.getConnection().getCatalog(), this.toStoredIdentifier(dbMeta, this.getSchema()), this.toStoredIdentifier(dbMeta, tableName), new String[]{"TABLE"});){
            if (!rs.next()) {
                throw new SQLException("Table [" + tableName + "] has not been found.");
            }
            String tableComment = rs.getString("REMARKS");
            TableInfo ti = new TableInfo(tableName);
            ti.setComment(tableComment);
            this.addColumnsToTableInfo(dbMeta, ti, doCheckForAutoIncrementColumns);
            this.addPrimaryKeyToTableInfo(dbMeta, ti);
            this.addForeignKeysToTableInfo(dbMeta, ti);
            this.addIndicesToTableInfo(dbMeta, ti, filter == null ? false : filter.isKeepInternalIndices());
            if (doCheckForAutoIncrementColumns) {
                this.checkAutoIncrementColumn(ti);
            }
            for (ColumnInfo ci : ti.getColumns()) {
                this.getDialect().fetchAdditionalColumnInfo(this, ti, ci);
            }
            TableInfo tableInfo = ti;
            return tableInfo;
        }
    }

    private static boolean isDoCheckAutoIncrementColumns(IndexFilter indexFilter) {
        try {
            if (indexFilter == null) {
                return true;
            }
            return indexFilter.isCheckForAutoIncrementColumns();
        }
        catch (AbstractMethodError e) {
            return true;
        }
    }

    @Override
    public List<TableInfo> fetchTableInfos(TableFilter filter) throws SQLException {
        ResultSet rs;
        Object str;
        log.info("Fetching all tables from catalog [" + this.getConnection().getCatalog() + "], schema [" + this.getSchema() + "].");
        DatabaseMetaData dbMeta = this.getConnection().getMetaData();
        this.maxTableNameLength = dbMeta.getMaxTableNameLength();
        log.info("fetch table infos [" + dbMeta.getDatabaseProductName() + ", version: " + dbMeta.getDatabaseProductVersion() + "].");
        boolean doCheckForAutoIncrementColumns = SchemaEngineImpl.isDoCheckAutoIncrementColumns(filter);
        try (ResultSet rs2 = dbMeta.getProcedures(null, this.toStoredIdentifier(dbMeta, this.getSchema()), "*");){
            ArrayList<String> func = new ArrayList<String>();
            while (rs2.next()) {
                func.add(rs2.getString(1));
            }
            String[] functions = new String[func.size()];
            func.toArray(functions);
            if (log.isDebugEnabled()) {
                str = "";
                for (String s : functions) {
                    str = (String)str + (String)s + ", ";
                }
                log.debug("Functions: [" + (String)str + "]");
            }
        }
        catch (Throwable e) {
            log.error("Error fetching table types.", e);
        }
        String[] tableTypes = null;
        try {
            rs = dbMeta.getTableTypes();
            try {
                ArrayList<String> tt = new ArrayList<String>();
                while (rs.next()) {
                    tt.add(rs.getString(1));
                }
                tableTypes = new String[tt.size()];
                tt.toArray(tableTypes);
                if (log.isDebugEnabled()) {
                    str = "";
                    for (String s : tt) {
                        str = (String)str + s + ", ";
                    }
                    log.debug("TableType: [" + (String)str + "]");
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (Exception e) {
            log.error("Error fetching table types.");
        }
        rs = dbMeta.getTables(this.getConnection().getCatalog(), this.toStoredIdentifier(dbMeta, this.getSchema()), null, new String[]{"TABLE"});
        try {
            LinkedList<TableInfo> ret = new LinkedList<TableInfo>();
            String rex = "\\w*";
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                if (!tableName.matches("\\w*")) {
                    log.info("ignqoring Table [" + tableName + "], doesn't match regular erpression: [\\w*].");
                    continue;
                }
                if (log.isDebugEnabled()) {
                    int cols = rs.getMetaData().getColumnCount();
                    for (int i = 1; i <= cols; ++i) {
                        Iterator<ColumnInfo> result = null;
                        int type = rs.getMetaData().getColumnType(i);
                        result = rs.getObject(i);
                        log.debug("\tcol[" + i + "] of type[" + type + "]=[" + String.valueOf(result) + "].");
                    }
                }
                if (filter != null && !filter.processTable(tableName)) {
                    log.info("Skipping table [" + tableName + "].");
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.info("Parsing structure of table [" + tableName + "].");
                }
                String tableComment = rs.getString("REMARKS");
                TableInfo ti = new TableInfo(tableName);
                ti.setComment(tableComment);
                try {
                    this.addColumnsToTableInfo(dbMeta, ti, doCheckForAutoIncrementColumns);
                    this.addPrimaryKeyToTableInfo(dbMeta, ti);
                    this.addForeignKeysToTableInfo(dbMeta, ti);
                    this.addIndicesToTableInfo(dbMeta, ti, filter == null ? false : filter.isKeepInternalIndices());
                    if (doCheckForAutoIncrementColumns) {
                        this.checkAutoIncrementColumn(ti);
                    }
                    for (ColumnInfo ci : ti.getColumns()) {
                        this.getDialect().fetchAdditionalColumnInfo(this, ti, ci);
                    }
                    ret.add(ti);
                }
                catch (Exception e) {
                    log.error("Error [" + e.getMessage() + "] in fetchTableInfos tableName=[" + tableName + "]");
                }
            }
            LinkedList<TableInfo> linkedList = ret;
            return linkedList;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    @Override
    public PreparedStatement createInsertStatement(TableInfo ti, boolean setAutoValues) throws SQLException {
        StringBuffer insertSql = new StringBuffer();
        String autoIncrementColumn = null;
        insertSql.append("insert into ");
        insertSql.append(ti.getName());
        insertSql.append(" (");
        List<ColumnInfo> columns = ti.getColumns();
        int i = 0;
        for (ColumnInfo ci : columns) {
            if (ci.isAutoIncrement()) {
                autoIncrementColumn = ci.getName();
                if (!setAutoValues) continue;
            }
            if (i > 0) {
                insertSql.append(',');
            }
            insertSql.append(ci.getName());
            ++i;
        }
        insertSql.append(") values (");
        i = 0;
        for (ColumnInfo ci : columns) {
            if (ci.isAutoIncrement() && !setAutoValues) continue;
            if (i > 0) {
                insertSql.append(',');
            }
            insertSql.append('?');
            ++i;
        }
        insertSql.append(")");
        if (autoIncrementColumn != null && !setAutoValues && this.getDialect() instanceof OracleDialect) {
            String[] generatedColumns = new String[]{autoIncrementColumn};
            return this.getConnection().prepareStatement(insertSql.toString(), generatedColumns);
        }
        if (autoIncrementColumn != null && setAutoValues && this.getDialect() instanceof MSSQLServerDialect) {
            return this.getConnection().prepareStatement("set identity_insert " + ti.getName() + " on " + insertSql.toString() + "set identity_insert " + ti.getName() + " off", 1);
        }
        if (setAutoValues || autoIncrementColumn == null) {
            return this.getConnection().prepareStatement(insertSql.toString());
        }
        return this.getConnection().prepareStatement(insertSql.toString(), 1);
    }

    @Override
    public void createTable(TableInfo ti, boolean addForeignKeys) throws SQLException {
        this.getDialect().pushCreateTable(this, this.queue, ti);
        if (ti.getIndices() != null) {
            this.createIndices(ti);
        }
        if (addForeignKeys) {
            this.createForeignKeys(ti);
        }
        this.queue.perform(this.getConnection());
    }

    @Override
    public TableInfo renameTable(TableInfo ti, String newTableName) throws SQLException {
        if (ti == null) {
            throw new SQLException("renameTable(TableInfo) called with tableInfo==null.");
        }
        this.getDialect().pushRenameTable(this, this.queue, ti, newTableName);
        this.queue.perform(this.getConnection());
        ti.setName(newTableName);
        return ti;
    }

    public void createIndices(TableInfo ti) throws SQLException {
        if (ti == null) {
            log.warn("createIndices(TableInfo) called with tableInfo==null.");
            return;
        }
        List<IndexInfo> indices = ti.getIndices();
        if (indices == null) {
            log.warn("createIndices(TableInfo) called with tableInfo.getIndices()==null.");
            return;
        }
        if (indices.size() == 0) {
            log.warn("createIndices(TableInfo) called with tableInfo.getIndices() empty.");
            return;
        }
        for (IndexInfo indexInfo : indices) {
            this.getDialect().pushAddIndex(this.queue, ti, indexInfo);
        }
        this.queue.perform(this.getConnection());
    }

    @Override
    public void createForeignKeys(TableInfo ti) throws SQLException {
        if (ti == null) {
            throw new SQLException("createForeignKeys(TableInfo) called with tableInfo==null.");
        }
        List<ForeignKeyInfo> foreignKeys = ti.getForeignKeys();
        if (foreignKeys == null || foreignKeys.size() == 0) {
            return;
        }
        for (ForeignKeyInfo foreignKeyInfo : foreignKeys) {
            this.getDialect().pushAddForeignKey(this.queue, ti, foreignKeyInfo);
        }
        this.queue.perform(this.getConnection());
    }

    @Override
    public TableInfo dropForeignKeys(TableInfo ti) throws SQLException {
        if (ti.getForeignKeys() == null) {
            return ti;
        }
        for (ForeignKeyInfo fki : ti.getForeignKeys()) {
            this.getDialect().pushDropForeignKey(this.queue, ti, fki);
        }
        this.queue.perform(this.getConnection());
        ti.setForeignKeys(null);
        return ti;
    }

    @Override
    public void dropTable(TableInfo ti, boolean force) throws SQLException {
        if (ti.getForeignKeys() != null) {
            for (ForeignKeyInfo fki : ti.getForeignKeys()) {
                this.getDialect().pushDropForeignKey(this.queue, ti, fki);
            }
        }
        this.getDialect().pushDropTable(this, this.queue, ti, force);
        this.queue.perform(this.getConnection());
    }

    @Override
    public void dropTables(List<TableInfo> tables, boolean force) throws SQLException {
        if (tables == null) {
            return;
        }
        for (TableInfo ti : tables) {
            if (ti.getForeignKeys() == null) continue;
            for (ForeignKeyInfo fki : ti.getForeignKeys()) {
                this.getDialect().pushDropForeignKey(this.queue, ti, fki);
            }
        }
        for (TableInfo ti : tables) {
            this.getDialect().pushDropTable(this, this.queue, ti, force);
        }
        this.queue.perform(this.getConnection());
    }

    @Override
    public TableInfo addColumn(TableInfo ti, ColumnInfo columnInfo) throws SQLException {
        if (ti == null) {
            throw new SQLException("Can't add column [" + (columnInfo == null ? "null" : columnInfo.getName()) + "], TableInfo is null.");
        }
        if (columnInfo == null) {
            throw new SQLException("Can't add column to table [" + ti.getName() + "], ColumnInfo is null.");
        }
        this.getDialect().pushAddColumn(this.queue, ti, columnInfo);
        this.queue.perform(this.getConnection());
        ti.addColumn(columnInfo);
        return ti;
    }

    @Override
    public TableInfo modifyColumn(TableInfo ti, ColumnInfo columnInfo) throws SQLException {
        if (ti == null) {
            throw new SQLException("Can't modify column [" + (columnInfo == null ? "null" : columnInfo.getName()) + "], TableInfo is null.");
        }
        if (columnInfo == null) {
            throw new SQLException("Can't modify column of table [" + ti.getName() + "], ColumnInfo is null.");
        }
        ColumnInfo oldColumnInfo = ti.getColumnInfo(columnInfo.getName());
        if (oldColumnInfo == null) {
            throw new SQLException("Can't modify column [" + columnInfo.getName() + "] of table [" + ti.getName() + "], column [" + columnInfo.getName() + "] does not exist.");
        }
        this.getDialect().pushModifyColumn(this, this.queue, ti, oldColumnInfo, columnInfo);
        this.queue.perform(this.getConnection());
        ti.replaceColumnInfo(columnInfo.getName(), columnInfo);
        return ti;
    }

    @Override
    public TableInfo changeColumn(TableInfo ti, String oldColumnName, ColumnInfo columnInfo) throws SQLException {
        if (ti == null) {
            throw new SQLException("Can't change column [" + (columnInfo == null ? "null" : columnInfo.getName()) + "], TableInfo is null.");
        }
        if (columnInfo == null) {
            throw new SQLException("Can't change column of table [" + ti.getName() + "], ColumnInfo is null.");
        }
        if (oldColumnName.equals(columnInfo.getName())) {
            return this.modifyColumn(ti, columnInfo);
        }
        ColumnInfo oldColumnInfo = ti.getColumnInfo(oldColumnName);
        if (oldColumnInfo == null) {
            throw new SQLException("Can't change column [" + columnInfo.getName() + "] of table [" + ti.getName() + "], column [" + columnInfo.getName() + "] does not exist.");
        }
        this.getDialect().pushChangeColumn(this, this.queue, ti, oldColumnInfo, columnInfo);
        this.queue.perform(this.getConnection());
        ti.replaceColumnInfo(oldColumnName, columnInfo);
        return ti;
    }

    @Override
    public TableInfo dropColumn(TableInfo ti, String columnName, boolean force) throws SQLException {
        if (ti == null) {
            throw new SQLException("Can't drop column [" + (columnName == null ? "null" : columnName) + "], TableInfo is null.");
        }
        if (columnName == null) {
            throw new SQLException("Can't drop column of table [" + ti.getName() + "], columnName is null.");
        }
        ColumnInfo ci = ti.getColumnInfo(columnName);
        if (ci == null) {
            throw new SQLException("Can't drop column [" + columnName + "] of table [" + ti.getName() + "], column [" + columnName + "] does not exist.");
        }
        this.getDialect().pushDropColumn(this, this.queue, ti, ci, force);
        this.queue.perform(this.getConnection());
        ti.removeColumnInfo(columnName);
        return ti;
    }

    @Override
    public TableInfo addForeignKey(TableInfo ti, ForeignKeyInfo foreignKeyInfo) throws SQLException {
        if (ti == null) {
            throw new SQLException("Can't add foreign key [" + (foreignKeyInfo == null ? "null" : foreignKeyInfo.getName()) + "], TableInfo is null.");
        }
        if (foreignKeyInfo == null) {
            throw new SQLException("Can't add foreign key to table [" + ti.getName() + "], ForeignKeyInfo is null.");
        }
        if (ti.getForeignKeyInfo(foreignKeyInfo.getName()) != null) {
            log.warn("Can't add foreign key [" + foreignKeyInfo.getName() + "] to table [" + ti.getName() + "], [" + foreignKeyInfo.getName() + "] already exists.");
            return ti;
        }
        this.getDialect().pushAddForeignKey(this.queue, ti, foreignKeyInfo);
        this.queue.perform(this.getConnection());
        ti.addForeignKey(foreignKeyInfo);
        return ti;
    }

    @Override
    public TableInfo dropForeignKey(TableInfo ti, String fkName) throws SQLException {
        if (ti == null) {
            throw new SQLException("Can't drop foreign key [" + (fkName == null ? "null" : fkName) + "], TableInfo is null.");
        }
        if (fkName == null) {
            throw new SQLException("Can't drop foreign key of table [" + ti.getName() + "], name of foreign key is null.");
        }
        ForeignKeyInfo fki = ti.getForeignKeyInfo(fkName);
        if (fki == null) {
            throw new SQLException("Can't drop foreign key [" + fkName + "] from table [" + ti.getName() + "], [" + fkName + "] does not exists.");
        }
        this.getDialect().pushDropForeignKey(this.queue, ti, fki);
        this.queue.perform(this.getConnection());
        ti.removeForeignKey(fkName);
        return ti;
    }

    @Override
    public TableInfo addIndex(TableInfo ti, IndexInfo indexInfo) throws SQLException {
        if (ti == null) {
            throw new SQLException("Can't add index [" + (indexInfo == null ? "null" : indexInfo.getName()) + "], TableInfo is null.");
        }
        if (indexInfo == null) {
            throw new SQLException("Can't add index to table [" + ti.getName() + "], indexInfo is null.");
        }
        if (ti.getIndexInfo(indexInfo.getName()) != null) {
            log.warn("Can't add index [" + indexInfo.getName() + "] to table [" + ti.getName() + "], [" + indexInfo.getName() + "] already exists.");
            return ti;
        }
        this.getDialect().pushAddIndex(this.queue, ti, indexInfo);
        this.queue.perform(this.getConnection());
        ti.addIndex(indexInfo);
        return ti;
    }

    @Override
    public TableInfo dropIndex(TableInfo ti, String indexName) throws SQLException {
        IndexInfo indexInfo = ti.getIndexInfo(indexName);
        if (indexInfo == null) {
            throw new SQLException("dropIndex: Index [" + indexName + "] does not exit in table [" + ti.getName() + "].");
        }
        this.getDialect().pushDropIndex(this.queue, ti, indexInfo);
        this.queue.perform(this.getConnection());
        ti.removeIndex(indexName);
        return ti;
    }

    @Override
    public void dropStaleBackupTables() throws SQLException {
        log.info("Fetching all stale backup tables from catalog [" + this.getConnection().getCatalog() + "], schema [" + this.getSchema() + "].");
        DatabaseMetaData dbMeta = this.getConnection().getMetaData();
        StringBuffer tableFilter = new StringBuffer("JDBC2XML");
        tableFilter.append(dbMeta.getSearchStringEscape());
        tableFilter.append('_');
        tableFilter.append(dbMeta.getSearchStringEscape());
        tableFilter.append('_');
        tableFilter.append('%');
        try (ResultSet rs = dbMeta.getTables(this.getConnection().getCatalog(), this.toStoredIdentifier(dbMeta, this.getSchema()), tableFilter.toString(), new String[]{"TABLE"});){
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                log.info("Dropping stale backup table [" + tableName + "].");
                SQLHelper.executeUpdate(this.getConnection(), DDLHelper.buildDropTable(tableName));
            }
        }
    }

    @Override
    public void commit() throws SQLException {
        this.queue.commit(this.getConnection());
    }

    @Override
    public void rollback() throws SQLException {
        this.queue.rollback(this.getConnection());
    }

    @Override
    public List<String> getTempTableNames() {
        ArrayList<String> res = new ArrayList<String>();
        Enumeration<SqlCommand> e = this.queue.commands();
        while (e.hasMoreElements()) {
            SqlCommand c = e.nextElement();
            if (!c.isTempTableCreated()) continue;
            res.add(c.getTempTableName());
        }
        return res;
    }

    @Override
    public int getMaxTableNameLength() {
        return this.maxTableNameLength;
    }

    @Override
    public SqlCommandQueue getQueue() {
        return this.queue;
    }
}

