/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.schema.impl;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Map;
import org.clazzes.jdbc2xml.schema.ISchemaEngine;
import org.clazzes.jdbc2xml.schema.ISchemaUpdateSnippet;
import org.clazzes.jdbc2xml.schema.TableInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaCheckerBean {
    private static final Logger log = LoggerFactory.getLogger(SchemaCheckerBean.class);
    private final Map<String, ISchemaUpdateSnippet> updateSnippets;
    private final ISchemaEngine engine;
    private String schemaVersion;
    private final TableInfo versionHistory;
    private final String insertSql;
    private final ISchemaUpdateSnippet baseMigration;

    public static String buildInsertSql(TableInfo versionHistory) {
        return "INSERT INTO " + versionHistory.getName() + " (" + versionHistory.getColumns().get(0).getName() + ", " + versionHistory.getColumns().get(1).getName() + ", " + versionHistory.getColumns().get(2).getName() + ", " + versionHistory.getColumns().get(3).getName() + ") VALUES (?,?,?,?)";
    }

    public SchemaCheckerBean(ISchemaEngine engine, Map<String, ISchemaUpdateSnippet> updateSnippets, TableInfo versionHistory, ISchemaUpdateSnippet baseVersion) {
        this.engine = engine;
        this.updateSnippets = updateSnippets;
        this.versionHistory = versionHistory;
        this.baseMigration = baseVersion;
        this.insertSql = SchemaCheckerBean.buildInsertSql(versionHistory);
    }

    public synchronized void checkSchema() throws SQLException, InstantiationException, IllegalAccessException {
        if (this.engine == null) {
            throw new RuntimeException("No database connection");
        }
        if ((this.updateSnippets == null || this.updateSnippets.size() < 1) && this.baseMigration == null) {
            return;
        }
        this.fetchSchemaVersion();
        this.updateDatabaseSchema();
    }

    private void fetchSchemaVersion() throws SQLException {
        this.schemaVersion = null;
        try (Statement stmt = this.engine.getConnection().createStatement();){
            try (ResultSet rs = stmt.executeQuery("SELECT VERSION FROM " + this.versionHistory.getName() + " ORDER BY SERIALNR DESC");){
                this.schemaVersion = rs.next() ? rs.getString(1) : null;
            }
            catch (SQLException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Problem detecting old DB schema. Suggesting empty DB.");
                }
                this.schemaVersion = null;
            }
        }
    }

    private void updateDatabaseSchema() throws SQLException, InstantiationException, IllegalAccessException {
        String sql = "SELECT " + this.versionHistory.getColumns().get(3).getName() + " FROM " + this.versionHistory.getName() + " ORDER BY " + this.versionHistory.getColumns().get(3).getName() + " DESC";
        if (log.isDebugEnabled()) {
            log.debug("Executing query [" + sql + "]");
        }
        try (PreparedStatement getSerialNr = this.engine.getConnection().prepareStatement(sql);){
            Integer serialNr;
            try (ResultSet rs = getSerialNr.executeQuery();){
                serialNr = rs.next() ? Integer.valueOf(rs.getInt(1)) : Integer.valueOf(-1);
            }
            try (PreparedStatement insertSchemaLog = this.engine.getConnection().prepareStatement(this.insertSql);){
                while (this.schemaVersion == null || this.updateSnippets != null && this.updateSnippets.containsKey(this.schemaVersion)) {
                    boolean success = false;
                    try (EngineClosable _e = new EngineClosable(this.engine);){
                        ISchemaUpdateSnippet snippet = this.schemaVersion == null ? this.baseMigration : this.updateSnippets.get(this.schemaVersion);
                        String newVersion = snippet.getTargetVersion();
                        log.info("Going to update DB schema from [" + this.schemaVersion + "] to [" + newVersion + "].");
                        snippet.performUpdate(this.engine);
                        insertSchemaLog.setString(1, newVersion);
                        insertSchemaLog.setString(2, snippet.getUpdateComment());
                        insertSchemaLog.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                        serialNr = serialNr + 1;
                        insertSchemaLog.setInt(4, serialNr);
                        insertSchemaLog.execute();
                        _e.commit();
                        log.info("Successfully updated schema from [" + this.schemaVersion + "] to [" + newVersion + "].");
                        this.schemaVersion = newVersion;
                        success = true;
                    }
                }
                log.info("schema is up to date (Version " + this.schemaVersion + ")");
            }
        }
    }

    private static final class EngineClosable
    implements AutoCloseable {
        private boolean done = false;
        private final ISchemaEngine engine;

        public EngineClosable(ISchemaEngine engine) {
            this.engine = engine;
        }

        public void commit() throws SQLException {
            if (this.done) {
                throw new RuntimeException();
            }
            this.engine.commit();
            this.done = true;
        }

        @Override
        public void close() throws SQLException {
            if (!this.done) {
                this.engine.rollback();
                this.done = true;
            }
        }
    }
}

