/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.schema.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import org.clazzes.jdbc2xml.helper.SQLHelper;
import org.clazzes.jdbc2xml.helper.TypesHelper;
import org.clazzes.jdbc2xml.schema.ColumnInfo;
import org.clazzes.jdbc2xml.schema.DataTypeNotSupportedException;
import org.clazzes.jdbc2xml.schema.ForeignKeyInfo;
import org.clazzes.jdbc2xml.schema.ISchemaEngine;
import org.clazzes.jdbc2xml.schema.IndexInfo;
import org.clazzes.jdbc2xml.schema.TableInfo;
import org.clazzes.jdbc2xml.schema.impl.AbstrDialectSupport;
import org.clazzes.jdbc2xml.schema.impl.ColumnHelper;
import org.clazzes.jdbc2xml.schema.impl.DDLHelper;
import org.clazzes.jdbc2xml.schema.impl.DropColumnCommand;
import org.clazzes.jdbc2xml.schema.impl.DropTableCommand;
import org.clazzes.jdbc2xml.sql.SqlCommandQueue;

public class PostgreSQLDialect
extends AbstrDialectSupport {
    public static final String defaultDriverName = "org.postgresql.Driver";
    private static final String addColumnCommand = "ADD COLUMN";
    private static final String dropConstraintCommand = "DROP CONSTRAINT";
    private static final String renameTableCommand = "ALTER TABLE %s RENAME TO %s";
    private static final String renameColumnCommand = "ALTER TABLE %s RENAME COLUMN %s TO %s";
    private static final String changeColumnDataTypeCommand = "ALTER TABLE %s ALTER COLUMN %s TYPE %s ";
    private static final String changeColumnDefaultValueCommand = "ALTER TABLE %s ALTER COLUMN %s SET %s";
    private static final String dropColumnDefaultValueCommand = "ALTER TABLE %s ALTER COLUMN %s DROP DEFAULT";
    private static final String setColumnNotNullCommand = "ALTER TABLE %s ALTER COLUMN %s SET NOT NULL";
    private static final String dropColumnNotNullCommand = "ALTER TABLE %s ALTER COLUMN %s DROP NOT NULL";

    @Override
    public String createColumnSpec(ColumnInfo columnInfo) {
        StringBuffer columnSpec = new StringBuffer();
        columnSpec.append(columnInfo.getName());
        columnSpec.append(" ");
        try {
            columnSpec.append(this.buildColumnDataType(columnInfo));
            columnSpec.append(this.buildColumnNullValues(columnInfo));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        String defValue = this.buildColumnDefaultValue(columnInfo);
        if (defValue != null && !defValue.equals("")) {
            columnSpec.append(defValue);
        }
        return columnSpec.toString();
    }

    private String buildColumnNullValues(ColumnInfo columnInfo) {
        if (!columnInfo.isNullable()) {
            return " NOT NULL";
        }
        return "";
    }

    private String buildColumnDefaultValue(ColumnInfo columnInfo) {
        StringBuffer spec = new StringBuffer();
        if (columnInfo.getDefaultValue() != null) {
            spec.append(" DEFAULT ");
            if (columnInfo.getType() == 16) {
                spec.append('\'');
                spec.append(columnInfo.getDefaultValue());
                spec.append('\'');
            } else if (TypesHelper.isNumeric(columnInfo.getType())) {
                spec.append(columnInfo.getDefaultValue());
            } else {
                spec.append('\'');
                this.quoteString(spec, columnInfo.getDefaultValue());
                spec.append('\'');
            }
        }
        return spec.toString();
    }

    private String buildColumnDataType(ColumnInfo columnInfo) throws IllegalArgumentException {
        StringBuffer spec = new StringBuffer();
        switch (columnInfo.getType()) {
            case 2003: {
                if (columnInfo.getPrecision() == null) {
                    throw new IllegalArgumentException();
                }
                spec.append("ARRAY[" + String.valueOf(columnInfo.getPrecision()) + "]");
                break;
            }
            case -5: {
                if (columnInfo.isAutoIncrement()) {
                    spec.append("SERIAL");
                    break;
                }
                spec.append("BIGINT");
                break;
            }
            case -2: {
                spec.append("BYTEA");
                break;
            }
            case -7: {
                if (columnInfo.getPrecision() == null) {
                    spec.append("BIT");
                    break;
                }
                spec.append("BIT(" + String.valueOf(columnInfo.getPrecision()) + ")");
                break;
            }
            case 16: {
                spec.append("BOOLEAN");
                break;
            }
            case -15: 
            case 1: {
                if (columnInfo.getPrecision() == null) {
                    spec.append("CHARACTER");
                    break;
                }
                spec.append("CHARACTER(" + String.valueOf(columnInfo.getPrecision()) + ")");
                break;
            }
            case 70: {
                throw new IllegalArgumentException();
            }
            case 91: {
                spec.append("DATE");
                break;
            }
            case 3: {
                if (columnInfo.getPrecision() == null) {
                    spec.append("DECIMAL");
                    break;
                }
                if (columnInfo.getScale() == null) {
                    spec.append("DECIMAL(" + String.valueOf(columnInfo.getPrecision()) + ")");
                    break;
                }
                spec.append("DECIMAL(" + String.valueOf(columnInfo.getPrecision()) + "," + String.valueOf(columnInfo.getScale()) + ")");
                break;
            }
            case 2001: {
                throw new IllegalArgumentException();
            }
            case 8: {
                spec.append("DOUBLE PRECISION");
                break;
            }
            case 6: {
                spec.append("FLOAT");
                break;
            }
            case 4: {
                if (columnInfo.isAutoIncrement()) {
                    spec.append("SERIAL");
                    break;
                }
                spec.append("INTEGER");
                break;
            }
            case 2000: {
                throw new IllegalArgumentException();
            }
            case -4: 
            case 2004: {
                spec.append("BYTEA");
                break;
            }
            case -16: 
            case -1: 
            case 2005: {
                spec.append("TEXT");
                break;
            }
            case 0: {
                throw new IllegalArgumentException();
            }
            case 2: {
                if (columnInfo.getPrecision() == null) {
                    spec.append("NUMERIC");
                    break;
                }
                if (columnInfo.getScale() == null) {
                    spec.append("NUMERIC(" + String.valueOf(columnInfo.getPrecision()) + ")");
                    break;
                }
                spec.append("NUMERIC(" + String.valueOf(columnInfo.getPrecision()) + "," + String.valueOf(columnInfo.getScale()) + ")");
                break;
            }
            case 1111: {
                throw new IllegalArgumentException();
            }
            case 7: {
                spec.append("REAL");
                break;
            }
            case 2006: {
                throw new IllegalArgumentException();
            }
            case 5: {
                spec.append("SMALLINT");
                break;
            }
            case 2002: {
                throw new IllegalArgumentException();
            }
            case 92: {
                spec.append("TIME");
                break;
            }
            case 93: {
                spec.append("TIMESTAMP");
                break;
            }
            case 2014: {
                spec.append("TIMESTAMPTZ");
                break;
            }
            case -6: {
                spec.append("SMALLINT");
                break;
            }
            case -3: {
                spec.append("BYTEA");
                break;
            }
            case -9: 
            case 12: {
                if (columnInfo.getPrecision() == null) {
                    spec.append("CHARACTER VARYING");
                    break;
                }
                spec.append("CHARACTER VARYING(" + String.valueOf(columnInfo.getPrecision()) + ")");
                break;
            }
            default: {
                throw new DataTypeNotSupportedException(columnInfo.getType());
            }
        }
        return spec.toString();
    }

    @Override
    public String defaultDriverName() {
        return defaultDriverName;
    }

    @Override
    public String getID() {
        return "POSTGRESQL_9";
    }

    @Override
    public String normalizeDefaultValue(int type, String s) {
        if (s == null) {
            return null;
        }
        if (s.startsWith("nextval(") && s.endsWith(")")) {
            return null;
        }
        if (s.startsWith("'") && (s.endsWith("'::character varying") || s.endsWith("'::bpchar") || s.endsWith("'::text"))) {
            return s.substring(1, s.lastIndexOf(39)).replace("''", "'");
        }
        if (type == -7) {
            if ("true".equals(s)) {
                return "1::bit";
            }
            if ("false".equals(s)) {
                return "0::bit";
            }
        }
        return s;
    }

    @Override
    public void pushAddColumn(SqlCommandQueue queue, TableInfo ti, ColumnInfo ci) throws SQLException {
        queue.pushCommand(DDLHelper.buildAddColumn(ti.getName(), ci, this, addColumnCommand, false), DDLHelper.buildDropColumn(ti.getName(), ci.getName()));
    }

    @Override
    public void pushAddForeignKey(SqlCommandQueue queue, TableInfo ti, ForeignKeyInfo fki) throws SQLException {
        queue.pushCommand(DDLHelper.buildAddForeignKey(ti.getName(), fki, false), DDLHelper.buildDropForeignKey(ti.getName(), fki.getName(), dropConstraintCommand));
    }

    @Override
    public void pushAddIndex(SqlCommandQueue queue, TableInfo ti, IndexInfo indexInfo) throws SQLException {
        queue.pushCommand(PostgreSQLDialect.buildAddIndex(ti, indexInfo), PostgreSQLDialect.buildDropIndex(ti, indexInfo));
    }

    private static String buildAddIndex(TableInfo ti, IndexInfo indexInfo) throws SQLException {
        return DDLHelper.buildAddIndex(ti, indexInfo, false, true);
    }

    private static String buildDropIndex(TableInfo ti, IndexInfo indexInfo) throws SQLException {
        return DDLHelper.buildDropIndex(ti.getName(), indexInfo.getName(), false);
    }

    @Override
    public void pushChangeColumn(ISchemaEngine schemaEngine, SqlCommandQueue queue, TableInfo ti, ColumnInfo oldColumnInfo, ColumnInfo newColumnInfo) throws SQLException {
        queue.pushCommand(String.format(renameColumnCommand, ti.getName(), oldColumnInfo.getName(), newColumnInfo.getName()), String.format(renameColumnCommand, ti.getName(), newColumnInfo.getName(), oldColumnInfo.getName()));
        ColumnInfo intermediateColumnInfo = new ColumnInfo(newColumnInfo.getName(), oldColumnInfo.getType(), oldColumnInfo.getPrecision(), oldColumnInfo.getScale(), oldColumnInfo.isNullable(), oldColumnInfo.getDefaultValue(), oldColumnInfo.isAutoIncrement());
        this.pushModifyColumn(schemaEngine, queue, ti, intermediateColumnInfo, newColumnInfo);
    }

    @Override
    public void pushCreateTable(ISchemaEngine schemaEngine, SqlCommandQueue queue, TableInfo ti) throws SQLException {
        queue.pushCommand(DDLHelper.buildCreateTable(ti, this, null), DDLHelper.buildDropTable(ti.getName()));
        String autoIncrementValueCommand = this.createAddAutoincrementValue(ti);
        if (autoIncrementValueCommand != null) {
            queue.pushQuerieCommand(autoIncrementValueCommand, this.createAddAutoincrementValueDefault(ti));
        }
    }

    private String createAddAutoincrementValue(TableInfo ti) throws SQLException {
        String sql = null;
        for (ColumnInfo ci : ti.getColumns()) {
            if (!ci.isAutoIncrement() || ci.getNextValue() == null) continue;
            StringBuffer spec = new StringBuffer();
            spec.append("SELECT SETVAL('");
            spec.append(ti.getName() + "_");
            spec.append(ci.getName() + "_seq'");
            spec.append(", ");
            spec.append(ci.getNextValue() - 1 + ")");
            sql = spec.toString();
            break;
        }
        return sql;
    }

    private String createAddAutoincrementValueDefault(TableInfo ti) throws SQLException {
        String sql = null;
        for (ColumnInfo ci : ti.getColumns()) {
            if (!ci.isAutoIncrement() || ci.getNextValue() == null) continue;
            StringBuffer spec = new StringBuffer();
            spec.append("SELECT SETVAL('");
            spec.append(ti.getName() + "_");
            spec.append(ci.getName() + "_seq'");
            spec.append(", ");
            spec.append("1)");
            sql = spec.toString();
            break;
        }
        return sql;
    }

    @Override
    public void pushDropColumn(ISchemaEngine schemaEngine, SqlCommandQueue queue, TableInfo ti, ColumnInfo ci, boolean force) throws SQLException {
        if (force) {
            queue.pushCommand(DDLHelper.buildDropColumn(ti.getName(), ci.getName()), DDLHelper.buildAddColumn(ti.getName(), ci, this, addColumnCommand, false));
        } else if (!ci.isNullable()) {
            ColumnInfo ciNull = ColumnHelper.adaptNullability(ci, true);
            this.pushModifyColumn(schemaEngine, queue, ti, ci, ciNull);
            queue.pushCommand(new DropColumnCommand(schemaEngine, ti, ciNull, this, null, addColumnCommand, false));
        } else {
            queue.pushCommand(new DropColumnCommand(schemaEngine, ti, ci, this, null, addColumnCommand, false));
        }
    }

    @Override
    public void pushDropForeignKey(SqlCommandQueue queue, TableInfo ti, ForeignKeyInfo fki) throws SQLException {
        queue.pushCommand(DDLHelper.buildDropForeignKey(ti.getName(), fki.getName(), dropConstraintCommand), DDLHelper.buildAddForeignKey(ti.getName(), fki, false));
    }

    @Override
    public void pushDropIndex(SqlCommandQueue queue, TableInfo ti, IndexInfo indexInfo) throws SQLException {
        queue.pushCommand(PostgreSQLDialect.buildDropIndex(ti, indexInfo), PostgreSQLDialect.buildAddIndex(ti, indexInfo));
    }

    @Override
    public void pushRenameTable(ISchemaEngine schemaEngine, SqlCommandQueue queue, TableInfo ti, String newTableName) throws SQLException {
        queue.pushCommand(DDLHelper.buildRenameTable(renameTableCommand, ti.getName(), newTableName));
    }

    @Override
    public void pushDropTable(ISchemaEngine schemaEngine, SqlCommandQueue queue, TableInfo ti, boolean force) throws SQLException {
        if (force) {
            queue.pushCommand(DDLHelper.buildDropTable(ti.getName()), null);
        } else {
            queue.pushCommand(new DropTableCommand(schemaEngine, ti, renameTableCommand, this));
        }
    }

    private static String getNullChangeCmd(ColumnInfo ci) {
        if (ci.isNullable()) {
            return dropColumnNotNullCommand;
        }
        return setColumnNotNullCommand;
    }

    private String buildChangeDefaultValueSql(String table, ColumnInfo ci) {
        if (ci.getDefaultValue() != null && !ci.getDefaultValue().equals("")) {
            return String.format(Locale.ENGLISH, changeColumnDefaultValueCommand, table, ci.getName(), this.buildColumnDefaultValue(ci));
        }
        return String.format(Locale.ENGLISH, dropColumnDefaultValueCommand, table, ci.getName());
    }

    @Override
    public void pushModifyColumn(ISchemaEngine schemaEngine, SqlCommandQueue queue, TableInfo ti, ColumnInfo oldColumnInfo, ColumnInfo newColumnInfo) throws SQLException {
        queue.pushCommand(String.format(changeColumnDataTypeCommand, ti.getName(), newColumnInfo.getName(), this.buildColumnDataType(newColumnInfo)), String.format(changeColumnDataTypeCommand, ti.getName(), oldColumnInfo.getName(), this.buildColumnDataType(oldColumnInfo)));
        queue.pushCommand(String.format(PostgreSQLDialect.getNullChangeCmd(newColumnInfo), ti.getName(), newColumnInfo.getName(), this.buildColumnNullValues(newColumnInfo)), String.format(PostgreSQLDialect.getNullChangeCmd(oldColumnInfo), ti.getName(), oldColumnInfo.getName()));
        if (!Objects.equals(oldColumnInfo.getDefaultValue(), newColumnInfo.getDefaultValue())) {
            queue.pushCommand(this.buildChangeDefaultValueSql(ti.getName(), newColumnInfo), this.buildChangeDefaultValueSql(ti.getName(), oldColumnInfo));
        }
    }

    @Override
    public void quoteString(StringBuffer sb, String s) {
        SQLHelper.quoteISOSqlString(sb, s);
    }

    @Override
    public String constructJDBCURL(String hostname, Integer port, String databaseName, Properties properties) {
        StringBuffer url = new StringBuffer("jdbc:postgresql://");
        if (hostname != null && hostname.length() > 0) {
            url.append(hostname);
        } else {
            url.append("localhost");
        }
        url.append(':');
        if (port != null && port > 0) {
            url.append(port);
        } else {
            url.append("5432");
        }
        if (databaseName != null && databaseName.length() > 0) {
            url.append(databaseName);
        }
        if (properties != null && properties.size() > 0) {
            int paramSep = 63;
            Enumeration<?> propertyNames = properties.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String propertyName = propertyNames.toString();
                String propertyValue = properties.getProperty(propertyName);
                url.append((char)paramSep);
                paramSep = 38;
                url.append(propertyName);
                url.append('=');
                url.append(propertyValue);
            }
        }
        return url.toString();
    }

    @Override
    public int getMappedSqlType(String dialectDataType) {
        switch (dialectDataType = dialectDataType.toUpperCase().replace(" ", "_").trim()) {
            case "TIMESTAMPTZ": {
                return 2014;
            }
            case "TIMESTAMP": {
                return 93;
            }
        }
        throw new DataTypeNotSupportedException(dialectDataType);
    }

    @Override
    public void fetchAdditionalColumnInfo(ISchemaEngine schemaEngine, TableInfo ti, ColumnInfo ci) {
        if (ci.isAutoIncrement()) {
            Connection con = schemaEngine.getConnection();
            try (Statement nextVal = con.createStatement(1003, 1008);){
                nextVal.setFetchSize(1);
                try (ResultSet result = nextVal.executeQuery("SELECT last_value FROM " + ti.getName() + "_" + ci.getName() + "_seq");){
                    if (result != null && result.next()) {
                        int nextValue = result.getInt(1);
                        ci.setNextValue(++nextValue);
                    }
                }
            }
            catch (SQLException e) {
                ci.setNextValue(1);
            }
        }
    }
}

