/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.schema.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import org.clazzes.jdbc2xml.helper.SQLHelper;
import org.clazzes.jdbc2xml.helper.TypesHelper;
import org.clazzes.jdbc2xml.schema.ColumnInfo;
import org.clazzes.jdbc2xml.schema.DataTypeNotSupportedException;
import org.clazzes.jdbc2xml.schema.ForeignKeyInfo;
import org.clazzes.jdbc2xml.schema.ISchemaEngine;
import org.clazzes.jdbc2xml.schema.IndexInfo;
import org.clazzes.jdbc2xml.schema.TableInfo;
import org.clazzes.jdbc2xml.schema.impl.AbstrDialectSupport;
import org.clazzes.jdbc2xml.schema.impl.ColumnHelper;
import org.clazzes.jdbc2xml.schema.impl.DDLHelper;
import org.clazzes.jdbc2xml.schema.impl.DropColumnCommand;
import org.clazzes.jdbc2xml.schema.impl.DropTableCommand;
import org.clazzes.jdbc2xml.schema.impl.NameHelper;
import org.clazzes.jdbc2xml.sql.SimpleSqlCommand;
import org.clazzes.jdbc2xml.sql.SqlCommand;
import org.clazzes.jdbc2xml.sql.SqlCommandQueue;
import org.clazzes.util.lang.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleDialect
extends AbstrDialectSupport {
    private static final Logger log = LoggerFactory.getLogger(OracleDialect.class);
    public static final String defaultDriverName = "oracle.jdbc.OracleDriver";
    public static final String OVERFLOW_TABLESPACE_PROPERTY = "overflowTablespace";
    public static final String OVERFLOW_TABLES_PROPERTY = "overflowTables";
    public static final String CREATE_BACKING_INDICES_PROPERTY = "createBackingIndices";
    private static final String addColumnCommand = "ADD";
    private static final String renameTableCommand = "RENAME %s TO %s";
    private static final String createTableSuffix = "ORGANIZATION INDEX";

    @Override
    public String getID() {
        return "Oracle_10";
    }

    @Override
    public void pushCreateTable(ISchemaEngine schemaEngine, SqlCommandQueue queue, TableInfo ti) {
        String overflowTables;
        String overflowTbs = this.getProperty(OVERFLOW_TABLESPACE_PROPERTY);
        if (log.isDebugEnabled()) {
            log.debug("Oracle: tableName=[{}], overflowTbs=[{}].", (Object)ti.getName(), (Object)overflowTbs);
        }
        Object suffix = overflowTbs == null ? createTableSuffix : ((overflowTables = this.getProperty(OVERFLOW_TABLES_PROPERTY)) == null || ti.getName().matches(overflowTables) ? "ORGANIZATION INDEX OVERFLOW TABLESPACE " + overflowTbs : createTableSuffix);
        queue.pushCommand(DDLHelper.buildCreateTable(ti, this, (String)suffix), DDLHelper.buildDropTable(ti.getName()));
        String createAutoIncrement = this.buildCreateAutoIncrementSequence(schemaEngine, ti, ti.getName());
        if (createAutoIncrement != null) {
            String dropAutoIncrement = this.buildDropAutoIncrementSequence(schemaEngine, ti, ti.getName());
            if (createAutoIncrement != null && dropAutoIncrement != null) {
                queue.pushCommand(createAutoIncrement, dropAutoIncrement);
                queue.pushCommand(this.buildCreateAutoIncrementTrigger(schemaEngine, ti, ti.getName()), this.buildDropAutoIncrementTrigger(schemaEngine, ti, ti.getName()));
            }
        }
    }

    private String buildDropAutoIncrementTrigger(ISchemaEngine schemaEngine, TableInfo ti, String tableName) {
        if (ti == null) {
            return null;
        }
        String autoIncrementCol = null;
        for (ColumnInfo ci : ti.getColumns()) {
            if (!ci.isAutoIncrement()) continue;
            autoIncrementCol = ci.getName();
            break;
        }
        if (autoIncrementCol != null) {
            String triggerName = this.createTriggerName(schemaEngine, tableName, autoIncrementCol);
            String sql = "drop trigger " + triggerName;
            return sql;
        }
        return null;
    }

    private String buildCreateAutoIncrementTrigger(ISchemaEngine schemaEngine, TableInfo ti, String tableName) {
        if (ti == null) {
            return null;
        }
        String autoIncrementCol = null;
        for (ColumnInfo ci : ti.getColumns()) {
            if (!ci.isAutoIncrement()) continue;
            autoIncrementCol = ci.getName();
            break;
        }
        if (autoIncrementCol != null) {
            String seqName = this.createSequenceName(schemaEngine, ti.getName(), autoIncrementCol);
            String triggerName = this.createTriggerName(schemaEngine, ti.getName(), autoIncrementCol);
            String sql = "CREATE OR REPLACE TRIGGER " + triggerName + " BEFORE INSERT ON " + ti.getName() + " REFERENCING NEW AS NEW FOR EACH ROW BEGIN   IF :NEW." + autoIncrementCol + " IS NULL THEN     SELECT " + seqName + ".NEXTVAL INTO :NEW." + autoIncrementCol + " FROM DUAL;   END IF; END;";
            return sql;
        }
        return null;
    }

    private String buildDropAutoIncrementSequence(ISchemaEngine schemaEngine, TableInfo ti, String tableName) {
        if (ti == null) {
            return null;
        }
        String autoIncrementCol = null;
        for (ColumnInfo ci : ti.getColumns()) {
            if (!ci.isAutoIncrement()) continue;
            autoIncrementCol = ci.getName();
            break;
        }
        if (autoIncrementCol != null) {
            String seqName = this.createSequenceName(schemaEngine, tableName, autoIncrementCol);
            String sql = "DROP SEQUENCE " + seqName;
            return sql;
        }
        return null;
    }

    private String createSequenceName(ISchemaEngine schemaEngine, String tableName, String autoIncrementCol) {
        return NameHelper.buildTempTableName(schemaEngine, tableName, autoIncrementCol, "sq").toUpperCase();
    }

    private String createTriggerName(ISchemaEngine schemaEngine, String tableName, String autoIncrementCol) {
        return NameHelper.buildTempTableName(schemaEngine, tableName, autoIncrementCol, "tr").toUpperCase();
    }

    private String buildCreateAutoIncrementSequence(ISchemaEngine schemaEngine, TableInfo ti, String tableName) {
        if (ti == null) {
            return null;
        }
        String autoIncrementCol = null;
        for (ColumnInfo ci : ti.getColumns()) {
            if (!ci.isAutoIncrement()) continue;
            autoIncrementCol = ci.getName();
            break;
        }
        if (autoIncrementCol != null) {
            String seqName = this.createSequenceName(schemaEngine, tableName, autoIncrementCol);
            String sql = "CREATE SEQUENCE " + seqName + " START WITH 1 INCREMENT BY 1 NOMAXVALUE";
            return sql;
        }
        return null;
    }

    @Override
    public void pushRenameTable(ISchemaEngine schemaEngine, SqlCommandQueue queue, TableInfo ti, String newTableName) throws SQLException {
        String dropAutoIncrementSequence = this.buildDropAutoIncrementSequence(schemaEngine, ti, ti.getName());
        if (dropAutoIncrementSequence != null) {
            queue.pushCommand(this.buildDropAutoIncrementTrigger(schemaEngine, ti, ti.getName()), this.buildCreateAutoIncrementTrigger(schemaEngine, ti, ti.getName()));
            queue.pushCommand(dropAutoIncrementSequence, this.buildCreateAutoIncrementSequence(schemaEngine, ti, ti.getName()));
        }
        queue.pushCommand(DDLHelper.buildRenameTable(renameTableCommand, ti.getName(), newTableName));
        dropAutoIncrementSequence = this.buildDropAutoIncrementSequence(schemaEngine, ti, newTableName);
        if (dropAutoIncrementSequence != null) {
            queue.pushCommand(this.buildCreateAutoIncrementTrigger(schemaEngine, ti, newTableName), this.buildDropAutoIncrementTrigger(schemaEngine, ti, newTableName));
            queue.pushCommand(this.buildCreateAutoIncrementSequence(schemaEngine, ti, newTableName), dropAutoIncrementSequence);
        }
    }

    @Override
    public void pushDropTable(ISchemaEngine schemaEngine, SqlCommandQueue queue, TableInfo ti, boolean force) throws SQLException {
        String dropAutoIncrementSequence = this.buildDropAutoIncrementSequence(schemaEngine, ti, ti.getName());
        if (dropAutoIncrementSequence != null) {
            queue.pushCommand(this.buildDropAutoIncrementTrigger(schemaEngine, ti, ti.getName()), this.buildCreateAutoIncrementTrigger(schemaEngine, ti, ti.getName()));
            queue.pushCommand(dropAutoIncrementSequence, this.buildCreateAutoIncrementSequence(schemaEngine, ti, ti.getName()));
        }
        if (force) {
            queue.pushCommand(DDLHelper.buildDropTable(ti.getName()), null);
        } else {
            queue.pushCommand(new DropTableCommand(schemaEngine, ti, renameTableCommand, this));
        }
    }

    private static StringBuffer appendColumnType(StringBuffer columnSpec, ColumnInfo columnInfo) {
        switch (columnInfo.getType()) {
            case -5: {
                columnSpec.append("NUMBER");
                break;
            }
            case -2: {
                if (columnInfo.getPrecision() == null) {
                    return null;
                }
                columnSpec.append("BLOB(" + String.valueOf(columnInfo.getPrecision()) + ")");
                break;
            }
            case -7: {
                if (columnInfo.getPrecision() == null) {
                    columnSpec.append("NUMBER(1)");
                    break;
                }
                columnSpec.append("NUMBER(" + String.valueOf(columnInfo.getPrecision()) + ")");
                break;
            }
            case 2004: {
                columnSpec.append("BLOB");
                break;
            }
            case 16: {
                columnSpec.append("NUMBER(1)");
                break;
            }
            case -15: 
            case 1: {
                if (columnInfo.getPrecision() == null) {
                    return null;
                }
                columnSpec.append("CHAR(" + String.valueOf(columnInfo.getPrecision()) + ")");
                break;
            }
            case 2005: {
                columnSpec.append("CLOB");
                break;
            }
            case 70: {
                return columnSpec.append("FILE");
            }
            case 91: {
                columnSpec.append("DATE");
                break;
            }
            case 3: {
                if (columnInfo.getPrecision() == null) {
                    columnSpec.append("NUMBER");
                    break;
                }
                if (columnInfo.getScale() == null) {
                    columnSpec.append("NUMBER(" + String.valueOf(columnInfo.getPrecision()) + ")");
                    break;
                }
                columnSpec.append("NUMBER(" + String.valueOf(columnInfo.getPrecision()) + "," + String.valueOf(columnInfo.getScale()) + ")");
                break;
            }
            case 8: {
                columnSpec.append("BINARY_DOUBLE");
                break;
            }
            case 6: {
                columnSpec.append("BINARY_FLOAT");
                break;
            }
            case 4: {
                columnSpec.append("NUMBER(11)");
                break;
            }
            case -4: {
                columnSpec.append("BLOB");
                break;
            }
            case -16: 
            case -1: {
                columnSpec.append("CLOB");
                break;
            }
            case 2: {
                if (columnInfo.getPrecision() == null) {
                    columnSpec.append("NUMBER");
                    break;
                }
                if (columnInfo.getScale() == null) {
                    columnSpec.append("NUMBER(" + String.valueOf(columnInfo.getPrecision()) + ")");
                    break;
                }
                columnSpec.append("NUMBER(" + String.valueOf(columnInfo.getPrecision()) + "," + String.valueOf(columnInfo.getScale()) + ")");
                break;
            }
            case 7: {
                columnSpec.append("NUMBER(*,7)");
                break;
            }
            case 5: {
                columnSpec.append("NUMBER(6)");
                break;
            }
            case 92: {
                columnSpec.append("TIMESTAMP");
                break;
            }
            case 93: {
                columnSpec.append("TIMESTAMP");
                break;
            }
            case 2014: {
                columnSpec.append("TIMESTAMP WITH TIME ZONE");
                break;
            }
            case -6: {
                columnSpec.append("NUMBER(3)");
                break;
            }
            case -3: {
                if (columnInfo.getPrecision() == null) {
                    columnSpec.append("RAW(255)");
                    break;
                }
                columnSpec.append("RAW(" + String.valueOf(columnInfo.getPrecision()) + ")");
                break;
            }
            case -9: 
            case 12: {
                if (columnInfo.getPrecision() == null) {
                    columnSpec.append("NVARCHAR2(255)");
                    break;
                }
                columnSpec.append("NVARCHAR2(" + String.valueOf(columnInfo.getPrecision()) + ")");
                break;
            }
            default: {
                throw new DataTypeNotSupportedException(columnInfo.getType());
            }
        }
        return columnSpec;
    }

    private void appendDefaultValue(StringBuffer columnSpec, ColumnInfo columnInfo, boolean query) {
        if (columnInfo.getDefaultValue() != null) {
            if (!query) {
                columnSpec.append(" default ");
            }
            if (TypesHelper.isNumeric(columnInfo.getType())) {
                columnSpec.append(columnInfo.getDefaultValue());
            } else {
                columnSpec.append('\'');
                this.quoteString(columnSpec, columnInfo.getDefaultValue());
                columnSpec.append('\'');
            }
        }
    }

    @Override
    public String createColumnSpec(ColumnInfo columnInfo) {
        StringBuffer columnSpec = new StringBuffer();
        columnSpec.append(columnInfo.getName());
        columnSpec.append(" ");
        if (OracleDialect.appendColumnType(columnSpec, columnInfo) == null) {
            return null;
        }
        this.appendDefaultValue(columnSpec, columnInfo, false);
        if (!columnInfo.isNullable()) {
            columnSpec.append(" NOT NULL");
        }
        return columnSpec.toString();
    }

    @Override
    public String defaultDriverName() {
        return defaultDriverName;
    }

    @Override
    public void quoteString(StringBuffer sb, String s) {
        SQLHelper.quoteISOSqlString(sb, s);
    }

    @Override
    public String normalizeDefaultValue(int type, String s) {
        if (s == null) {
            return null;
        }
        s = s.substring(0, s.length() - 1);
        if (TypesHelper.isNumeric(type)) {
            if (s.startsWith("((") && s.endsWith("))")) {
                return s.substring(2, s.length() - 2);
            }
            return s.trim();
        }
        if ("''".equals(s)) {
            return null;
        }
        if (s.startsWith("''") && s.endsWith("''")) {
            s = s.substring(2, s.length() - 2);
        }
        s = SQLHelper.unquoteISOSqlString(s);
        return s;
    }

    private static final IndexInfo makeBackingIndexInfo(ForeignKeyInfo fk) {
        IndexInfo ret = new IndexInfo();
        if (fk.getName() != null) {
            String fkNameUpper = fk.getName().toUpperCase(Locale.ENGLISH);
            if (fkNameUpper.endsWith("_FK")) {
                ret.setName(fkNameUpper.substring(0, fk.getName().length() - 3) + "_BK");
            } else if (fkNameUpper.startsWith("FK_")) {
                ret.setName("BK_" + fkNameUpper.substring(3));
            } else {
                ret.setName(fkNameUpper + "_BK");
            }
        }
        ret.setColumns(fk.getColumns());
        ret.setUnique(false);
        return ret;
    }

    private static String buildDropForeignKey(TableInfo ti, ForeignKeyInfo fki) {
        return DDLHelper.buildDropForeignKey(ti.getName(), fki.getName(), "DROP CONSTRAINT");
    }

    protected boolean isCreateBackingIndices() {
        String createBackingIndices_s = this.getProperty(CREATE_BACKING_INDICES_PROPERTY);
        return createBackingIndices_s == null ? true : Boolean.parseBoolean(createBackingIndices_s);
    }

    @Override
    public void pushAddForeignKey(SqlCommandQueue queue, TableInfo ti, ForeignKeyInfo fki) throws SQLException {
        if (this.isCreateBackingIndices()) {
            queue.pushCommand(new AddForeignKeyCommand(ti, fki));
        } else {
            queue.pushCommand(new SimpleSqlCommand(DDLHelper.buildAddForeignKey(ti.getName(), fki, false), OracleDialect.buildDropForeignKey(ti, fki)));
        }
    }

    @Override
    public void pushDropForeignKey(SqlCommandQueue queue, TableInfo ti, ForeignKeyInfo fki) throws SQLException {
        if (this.isCreateBackingIndices()) {
            queue.pushCommand(new DropForeignKeyCommand(ti, fki));
        } else {
            queue.pushCommand(new SimpleSqlCommand(OracleDialect.buildDropForeignKey(ti, fki), DDLHelper.buildAddForeignKey(ti.getName(), fki, false)));
        }
    }

    private static String buildAddIndex(TableInfo ti, IndexInfo indexInfo) throws SQLException {
        return DDLHelper.buildAddIndex(ti, indexInfo, false, false);
    }

    private static String buildDropIndex(TableInfo ti, IndexInfo indexInfo) throws SQLException {
        return DDLHelper.buildDropIndex(ti.getName(), indexInfo.getName(), false);
    }

    @Override
    public void pushAddIndex(SqlCommandQueue queue, TableInfo ti, IndexInfo indexInfo) throws SQLException {
        queue.pushCommand(OracleDialect.buildAddIndex(ti, indexInfo), OracleDialect.buildDropIndex(ti, indexInfo));
    }

    @Override
    public void pushDropIndex(SqlCommandQueue queue, TableInfo ti, IndexInfo indexInfo) throws SQLException {
        queue.pushCommand(OracleDialect.buildDropIndex(ti, indexInfo), OracleDialect.buildAddIndex(ti, indexInfo));
    }

    private String buildAddColumn(TableInfo ti, ColumnInfo ci) {
        return DDLHelper.buildAddColumn(ti.getName(), ci, this, addColumnCommand, true);
    }

    @Override
    public void pushAddColumn(SqlCommandQueue queue, TableInfo ti, ColumnInfo ci) throws SQLException {
        if (ci.getDefaultValue() == null) {
            queue.pushCommand(this.buildAddColumn(ti, ci), DDLHelper.buildDropColumn(ti.getName(), ci.getName()));
        } else {
            StringBuffer sql = new StringBuffer();
            sql.append("ALTER TABLE ");
            sql.append(ti.getName());
            sql.append(" ADD ( ");
            sql.append(this.createColumnSpec(ci));
            sql.append(")");
            StringBuffer rsql = new StringBuffer();
            rsql.append("ALTER TABLE ");
            rsql.append(ti.getName());
            rsql.append(" DROP COLUMN ");
            rsql.append(ci.getName());
            queue.pushCommand(sql.toString(), rsql.toString());
        }
    }

    @Override
    public void pushDropColumn(ISchemaEngine schemaEngine, SqlCommandQueue queue, TableInfo ti, ColumnInfo ci, boolean force) throws SQLException {
        if (ci.getDefaultValue() != null) {
            queue.pushCommand(new ModifyDefaultValueCommand(ti.getName(), ci, true, this));
        }
        ColumnInfo ciNoDef = ColumnHelper.adaptDefault(ci, null);
        if (force) {
            SimpleSqlCommand command = new SimpleSqlCommand(DDLHelper.buildDropColumn(ti.getName(), ci.getName()), this.buildAddColumn(ti, ciNoDef));
            queue.pushCommand(command);
        } else if (!ci.isNullable()) {
            ColumnInfo ciNull = ColumnHelper.adaptNullability(ciNoDef, true);
            this.pushModifyColumnType(queue, ti, ciNoDef, ciNull);
            DropColumnCommand command = new DropColumnCommand(schemaEngine, ti, ciNull, this, null, addColumnCommand, true);
            queue.pushCommand(command);
        } else {
            DropColumnCommand command = new DropColumnCommand(schemaEngine, ti, ciNoDef, this, null, addColumnCommand, true);
            queue.pushCommand(command);
        }
    }

    private String buildAlterColumn(String tableName, ColumnInfo newColumnInfo, ColumnInfo oldColumnInfo) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("ALTER TABLE ");
        sql.append(tableName);
        sql.append(" MODIFY ( ");
        sql.append(newColumnInfo.getName());
        sql.append(' ');
        if (OracleDialect.appendColumnType(sql, newColumnInfo) == null) {
            throw new SQLException("Cannot modify column [" + newColumnInfo.getName() + "] to type [" + TypesHelper.typeToString(newColumnInfo.getType()) + "]: Type is not supported.");
        }
        this.appendDefaultValue(sql, newColumnInfo, false);
        if (newColumnInfo.isNullable() != oldColumnInfo.isNullable()) {
            if (newColumnInfo.isNullable()) {
                sql.append(" NULL");
            } else {
                sql.append(" NOT NULL");
            }
        }
        sql.append(" )");
        return sql.toString();
    }

    private void pushModifyColumnType(SqlCommandQueue queue, TableInfo ti, ColumnInfo oldColumnInfo, ColumnInfo newColumnInfo) throws SQLException {
        if (Util.equalsNullAware((Object)oldColumnInfo.getPrecision(), (Object)newColumnInfo.getPrecision()) && Util.equalsNullAware((Object)oldColumnInfo.getScale(), (Object)newColumnInfo.getScale()) && oldColumnInfo.getType() == newColumnInfo.getType() && oldColumnInfo.isNullable() == newColumnInfo.isNullable()) {
            return;
        }
        queue.pushCommand(this.buildAlterColumn(ti.getName(), newColumnInfo, oldColumnInfo), this.buildAlterColumn(ti.getName(), oldColumnInfo, newColumnInfo));
    }

    @Override
    public void pushChangeColumn(ISchemaEngine schemaEngine, SqlCommandQueue queue, TableInfo ti, ColumnInfo oldColumnInfo, ColumnInfo newColumnInfo) throws SQLException {
        ColumnInfo tmpInfo = ColumnHelper.adaptNullability(newColumnInfo, true);
        this.pushAddColumn(queue, ti, tmpInfo);
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ");
        sql.append(ti.getName());
        sql.append(" SET ");
        sql.append(newColumnInfo.getName());
        sql.append(" = ");
        sql.append(oldColumnInfo.getName());
        StringBuffer rsql = new StringBuffer();
        rsql.append("UPDATE ");
        rsql.append(ti.getName());
        rsql.append(" SET ");
        rsql.append(newColumnInfo.getName());
        rsql.append(" = NULL");
        queue.pushCommand(sql.toString(), rsql.toString());
        sql.delete(0, sql.length());
        rsql.delete(0, rsql.length());
        if (!newColumnInfo.isNullable()) {
            this.pushModifyColumnType(queue, ti, tmpInfo, newColumnInfo);
        }
        this.pushDropColumn(schemaEngine, queue, ti, oldColumnInfo, true);
    }

    @Override
    public void pushModifyColumn(ISchemaEngine schemaEngine, SqlCommandQueue queue, TableInfo ti, ColumnInfo oldColumnInfo, ColumnInfo newColumnInfo) throws SQLException {
        boolean defaultValueChanged;
        boolean bl = defaultValueChanged = !Util.equalsNullAware((Object)oldColumnInfo.getDefaultValue(), (Object)newColumnInfo.getDefaultValue());
        if (defaultValueChanged) {
            if (oldColumnInfo.getDefaultValue() != null) {
                queue.pushCommand(new ModifyDefaultValueCommand(ti.getName(), oldColumnInfo, true, this));
            }
            if (newColumnInfo.getDefaultValue() != null) {
                queue.pushCommand(new ModifyDefaultValueCommand(ti.getName(), newColumnInfo, false, this));
            }
        }
        this.pushModifyColumnType(queue, ti, oldColumnInfo, newColumnInfo);
    }

    @Override
    public String constructJDBCURL(String hostname, Integer port, String databaseName, Properties properties) {
        StringBuffer url = new StringBuffer("jdbc:oracle:thin:@");
        String iphost = null;
        String sid = null;
        if (hostname != null && hostname.length() > 0) {
            if (hostname.contains("/")) {
                iphost = hostname.substring(0, hostname.indexOf(47));
                sid = hostname.substring(hostname.indexOf(47) + 1, hostname.length());
                url.append(iphost);
            } else {
                url.append(hostname);
            }
        } else {
            url.append("localhost");
        }
        url.append(':');
        if (port != null && port > 0) {
            url.append(port);
        } else {
            url.append("1521");
        }
        if (sid != null) {
            url.append(':');
            url.append(sid);
        }
        if (properties != null && properties.size() > 0) {
            url.append(';');
            Enumeration<?> propertyNames = properties.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String propertyName = propertyNames.toString();
                String propertyValue = properties.getProperty(propertyName);
                url.append(propertyName);
                url.append('=');
                url.append(propertyValue);
                url.append(';');
            }
        }
        return url.toString();
    }

    @Override
    public int getMappedSqlType(String dialectDataType) {
        String effectiveType = dialectDataType.replace(' ', '_').replaceAll("\\(.*?\\)", "").trim();
        switch (OracleDataType.valueOf(effectiveType)) {
            case CHAR: {
                return 1;
            }
            case VARCHAR2: {
                return 12;
            }
            case VARCHAR: {
                return 12;
            }
            case NCHAR: {
                return 12;
            }
            case NVARCHAR2: {
                return 12;
            }
            case DATE: {
                return 91;
            }
            case BLOB: {
                return 2004;
            }
            case CLOB: {
                return 2005;
            }
            case NCLOB: {
                return 2011;
            }
            case BFILE: {
                throw new DataTypeNotSupportedException(dialectDataType);
            }
            case LONG: {
                throw new DataTypeNotSupportedException(dialectDataType);
            }
            case LONG_RAW: {
                throw new DataTypeNotSupportedException(dialectDataType);
            }
            case LONG_VARCHAR: {
                throw new DataTypeNotSupportedException(dialectDataType);
            }
            case RAW: {
                return 2004;
            }
            case NUMBER: {
                return 2;
            }
            case DECIMAL: {
                return 3;
            }
            case FLOAT: {
                return 6;
            }
            case INTEGER: {
                return 4;
            }
            case MLSLABEL: {
                throw new DataTypeNotSupportedException(dialectDataType);
            }
            case SMALLINT: {
                return 5;
            }
            case RAW_MLSLABEL: {
                throw new DataTypeNotSupportedException(dialectDataType);
            }
            case ROWID: {
                throw new DataTypeNotSupportedException(dialectDataType);
            }
            case TIMESTAMP: {
                return 93;
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                return 2014;
            }
        }
        throw new DataTypeNotSupportedException(dialectDataType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fetchAdditionalColumnInfo(ISchemaEngine schemaEngine, TableInfo ti, ColumnInfo ci) {
        String seqName = this.createSequenceName(schemaEngine, ti.getName(), ci.getName());
        ResultSet rs = null;
        try {
            PreparedStatement ps = schemaEngine.getConnection().prepareStatement("select * from USER_SEQUENCES");
            rs = ps.executeQuery();
            while (rs.next()) {
                String res = rs.getString(1);
                if (!seqName.equalsIgnoreCase(res)) continue;
                log.debug("found sequence [" + res + "] for table=[" + ti.getName() + "], column=[" + ci.getName() + "]");
                ci.setAutoIncrement(true);
            }
        }
        catch (SQLException e) {
            if (log.isDebugEnabled()) {
                log.debug("fetchAdditionalColumnInfo: ", (Throwable)e);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private static class AddForeignKeyCommand
    extends SimpleSqlCommand {
        private final String addKey;
        private final String dropKey;

        public AddForeignKeyCommand(TableInfo ti, ForeignKeyInfo fki) throws SQLException {
            super(DDLHelper.buildAddForeignKey(ti.getName(), fki, false), OracleDialect.buildDropForeignKey(ti, fki));
            IndexInfo bkInfo = OracleDialect.makeBackingIndexInfo(fki);
            this.addKey = DDLHelper.buildAddIndex(ti, bkInfo, false, false);
            this.dropKey = DDLHelper.buildDropIndex(ti.getName(), bkInfo.getName(), false);
        }

        @Override
        public void perform(Connection connection) throws SQLException {
            if (log.isDebugEnabled()) {
                log.debug("Running backing key create statement [" + this.addKey + "].");
            }
            SQLHelper.executeUpdate(connection, this.addKey);
            super.perform(connection);
        }

        @Override
        public void rollback(Connection connection) throws SQLException {
            super.rollback(connection);
            if (log.isDebugEnabled()) {
                log.debug("Running rollback statement [" + this.dropKey + "].");
            }
            try {
                SQLHelper.executeUpdate(connection, this.dropKey);
            }
            catch (SQLException e) {
                if (e.getErrorCode() == 1418) {
                    if (log.isDebugEnabled()) {
                        log.debug("SQL error 1418 dropping backing index through command [" + this.dropKey + "] during rollback of add foreign key.");
                    }
                }
                throw e;
            }
        }
    }

    private static class DropForeignKeyCommand
    extends SimpleSqlCommand {
        private final String addKey;
        private final String dropKey;

        public DropForeignKeyCommand(TableInfo ti, ForeignKeyInfo fki) throws SQLException {
            super(OracleDialect.buildDropForeignKey(ti, fki), DDLHelper.buildAddForeignKey(ti.getName(), fki, false));
            IndexInfo bkInfo = OracleDialect.makeBackingIndexInfo(fki);
            this.addKey = DDLHelper.buildAddIndex(ti, bkInfo, false, false);
            this.dropKey = DDLHelper.buildDropIndex(ti.getName(), bkInfo.getName(), false);
        }

        @Override
        public void perform(Connection connection) throws SQLException {
            super.perform(connection);
            if (log.isDebugEnabled()) {
                log.debug("Running drop backing key statement [" + this.dropKey + "].");
            }
            try {
                SQLHelper.executeUpdate(connection, this.dropKey);
            }
            catch (SQLException e) {
                if (e.getErrorCode() == 1418) {
                    if (log.isDebugEnabled()) {
                        log.debug("SQL error 1418 dropping backing index through command [" + this.dropKey + "].");
                    }
                }
                throw e;
            }
        }

        @Override
        public void rollback(Connection connection) throws SQLException {
            if (log.isDebugEnabled()) {
                log.debug("Running backing key create statement [" + this.addKey + "] during rollback.");
            }
            try {
                SQLHelper.executeUpdate(connection, this.addKey);
            }
            catch (SQLException e) {
                if (e.getErrorCode() == 1408) {
                    if (log.isDebugEnabled()) {
                        log.debug("SQL error 1408 dropping backing index through command [" + this.addKey + "].");
                    }
                }
                throw e;
            }
            super.rollback(connection);
        }
    }

    private static class ModifyDefaultValueCommand
    implements SqlCommand {
        private String table;
        private String column;
        private String performSql;
        private String rollbackSql;

        private void dropDefaultValue(Connection connection) throws SQLException {
            if (this.table == null || this.column == null) {
                throw new SQLException("This statement has already been committed.");
            }
            Statement statement = connection.createStatement();
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT dl.name FROM sys.tables AS tl,sys.columns AS cl,sys.default_constraints AS dl WHERE tl.name = '");
            sql.append(this.table);
            sql.append("' AND cl.object_id = tl.object_id AND cl.name = '");
            sql.append(this.column);
            sql.append("' AND dl.parent_object_id = tl.object_id AND dl.parent_column_id = cl.column_id");
            ResultSet rs = statement.executeQuery(sql.toString());
            if (!rs.next()) {
                throw new SQLException("Deafult value contraint for column [" + this.column + "] on table [" + this.table + "] could not be found.");
            }
            sql.delete(0, sql.length());
            sql.append("ALTER TABLE ");
            sql.append(this.table);
            sql.append(" DROP CONSTRAINT ");
            sql.append(rs.getString(1));
            rs.close();
            if (log.isDebugEnabled()) {
                log.debug("Executing drop default value statement [" + String.valueOf(sql) + "].");
            }
            statement.executeUpdate(sql.toString());
            statement.close();
        }

        public ModifyDefaultValueCommand(String table, ColumnInfo column, boolean drop, OracleDialect dialect) {
            this.table = table;
            this.column = column.getName();
            StringBuffer sql = new StringBuffer();
            sql.append("ALTER TABLE ");
            sql.append(table);
            sql.append(" MODIFY ( ");
            sql.append(column.getName());
            dialect.appendDefaultValue(sql, column, false);
            sql.append(" )");
            if (drop) {
                this.performSql = null;
                this.rollbackSql = sql.toString();
            } else {
                this.performSql = sql.toString();
                this.rollbackSql = null;
            }
        }

        @Override
        public void perform(Connection connection) throws SQLException {
            if (this.performSql != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Executing add default value statement [" + this.performSql + "].");
                }
                SQLHelper.executeUpdate(connection, this.performSql);
            } else if (this.rollbackSql != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Executing drop default value statement [" + this.rollbackSql + "].");
                }
                SQLHelper.executeUpdate(connection, this.rollbackSql);
            } else {
                this.dropDefaultValue(connection);
            }
        }

        @Override
        public void rollback(Connection connection) throws SQLException {
            if (this.rollbackSql != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Executing add default value statement [" + this.rollbackSql + "] during rollback.");
                }
                SQLHelper.executeUpdate(connection, this.rollbackSql);
            } else if (this.performSql != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Executing add default value statement [" + this.performSql + "] during rollback.");
                }
                SQLHelper.executeUpdate(connection, this.performSql);
            } else {
                this.dropDefaultValue(connection);
            }
        }

        @Override
        public void cleanupOnCommit(Connection connection) throws SQLException {
            this.column = null;
            this.table = null;
            this.performSql = null;
            this.rollbackSql = null;
        }

        @Override
        public String getTempTableName() {
            return null;
        }

        @Override
        public boolean isTempTableCreated() {
            return false;
        }
    }

    static enum OracleDataType {
        CHAR,
        VARCHAR2,
        VARCHAR,
        NCHAR,
        NVARCHAR2,
        DATE,
        BLOB,
        CLOB,
        NCLOB,
        BFILE,
        LONG,
        LONG_RAW,
        LONG_VARCHAR,
        RAW,
        NUMBER,
        DECIMAL,
        FLOAT,
        INTEGER,
        MLSLABEL,
        SMALLINT,
        RAW_MLSLABEL,
        ROWID,
        TIMESTAMP,
        TIMESTAMP_WITH_TIME_ZONE;

    }
}

