/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.schema.impl;

import org.clazzes.jdbc2xml.schema.ISchemaEngine;

public class NameHelper {
    public static String buildTempTableName(ISchemaEngine schemaEngine, String tableName, String columnName, String suffix) {
        String delimiter = "__";
        String schema = schemaEngine.getSchema();
        schema = schema == null || schema.length() == 0 ? "JDBC2XML" : schema;
        int maxNameLength = schemaEngine.getMaxTableNameLength();
        if (suffix == null) {
            suffix = "";
        }
        StringBuilder tmp = null;
        new StringBuilder();
        int run = 0;
        do {
            tmp = new StringBuilder();
            switch (run) {
                case 0: {
                    tmp.append(schema);
                    tmp.append(delimiter);
                    tmp.append(tableName);
                    tmp.append(delimiter);
                    if (columnName != null) {
                        tmp.append(columnName);
                        tmp.append(delimiter);
                    }
                    tmp.append(suffix);
                    break;
                }
                case 1: {
                    delimiter = "_";
                    tmp.append(schema);
                    tmp.append(delimiter);
                    tmp.append(tableName);
                    tmp.append(delimiter);
                    if (columnName != null) {
                        tmp.append(columnName);
                        tmp.append(delimiter);
                    }
                    tmp.append(suffix);
                    break;
                }
                default: {
                    delimiter = "_";
                    tmp.append(NameHelper.shortString(schema, run - 1));
                    tmp.append(delimiter);
                    tmp.append(NameHelper.shortString(tableName, run - 1));
                    tmp.append(delimiter);
                    if (columnName != null) {
                        tmp.append(NameHelper.shortString(columnName, run - 1));
                        tmp.append(delimiter);
                    }
                    tmp.append(suffix);
                }
            }
            ++run;
        } while (tmp.length() > maxNameLength);
        return tmp.toString();
    }

    private static String shortString(String src, int factor) {
        Object res = src;
        if (src == null) {
            return "";
        }
        if (src.length() < 3) {
            return src;
        }
        for (int i = 0; i < factor; ++i) {
            res = ((String)res).substring(0, ((String)res).length() / 3) + ((String)res).substring(((String)res).length() / 3 * 2, ((String)res).length());
        }
        return res;
    }
}

