/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.schema.impl;

import org.clazzes.jdbc2xml.schema.ColumnInfo;
import org.clazzes.util.lang.Util;

public abstract class ColumnHelper {
    public static ColumnInfo adaptNullability(ColumnInfo ci, boolean nullable) {
        if (ci.isNullable() == nullable) {
            return ci;
        }
        return new ColumnInfo(ci.getName(), ci.getType(), ci.getPrecision(), ci.getScale(), nullable, ci.getDefaultValue());
    }

    public static ColumnInfo adaptDefault(ColumnInfo ci, String defaultValue) {
        if (Util.equalsNullAware((Object)ci.getDefaultValue(), (Object)defaultValue)) {
            return ci;
        }
        return new ColumnInfo(ci.getName(), ci.getType(), ci.getPrecision(), ci.getScale(), ci.isNullable(), defaultValue);
    }

    public static ColumnInfo rename(ColumnInfo ci, String name) {
        if (Util.equalsNullAware((Object)ci.getName(), (Object)name)) {
            return ci;
        }
        return new ColumnInfo(name, ci.getType(), ci.getPrecision(), ci.getScale(), ci.isNullable(), ci.getDefaultValue());
    }
}

