/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.schema;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.clazzes.jdbc2xml.schema.ColumnInfo;
import org.clazzes.jdbc2xml.schema.ISchemaEngine;
import org.clazzes.jdbc2xml.schema.ISchemaUpdateSnippet;
import org.clazzes.jdbc2xml.schema.PrimaryKeyInfo;
import org.clazzes.jdbc2xml.schema.SchemaManagementException;
import org.clazzes.jdbc2xml.schema.TableInfo;
import org.clazzes.jdbc2xml.schema.impl.SchemaCheckerBean;
import org.clazzes.jdbc2xml.schema.impl.SchemaEngineFactoryImpl;
import org.clazzes.util.lang.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaManager {
    private static final Logger log = LoggerFactory.getLogger(SchemaManager.class);
    @Deprecated
    public static final TableInfo VERSION_HISTORY = SchemaManager.makeVersionHistoryInfo("SCHEMA_HISTORY", null);
    private String baseVersion = "0.1.00";
    private String versionHistoryTable = "SCHEMA_HISTORY";
    private String versionHistorySchema = null;
    private String baseDescription = "initial database schema";
    private List<TableInfo> baseTables;
    private DataSource dataSource;
    private ISchemaEngine schemaEngine;
    private Map<String, String> dialectProperties;
    private Map<String, ISchemaUpdateSnippet> updateSnippets;
    private ISchemaUpdateSnippet baseMigration;

    private static TableInfo makeVersionHistoryInfo(String tableName, String schemaName) {
        TableInfo ti = new TableInfo();
        ti.setName((String)(schemaName == null ? tableName : schemaName + "." + tableName));
        ti.setColumns(Arrays.asList(new ColumnInfo("VERSION", 12, 10, null, false, null), new ColumnInfo("DESCRIPTION", 12, 512, null, true, null), new ColumnInfo("CREATION_DATE", 93, 12, null, true, null), new ColumnInfo("SERIALNR", 4, 5, null, false, null)));
        ti.setPrimaryKey(new PrimaryKeyInfo(tableName + "_PK", "VERSION"));
        return ti;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withSchema(String schemaName, Supplier<T> fn) {
        if (schemaName == null) {
            return fn.get();
        }
        String oldSchema = this.schemaEngine.getSchema();
        this.schemaEngine.setSchema(schemaName);
        try {
            T t = fn.get();
            return t;
        }
        finally {
            this.schemaEngine.setSchema(oldSchema);
        }
    }

    public SchemaManager() {
    }

    public SchemaManager(String baseVersion, List<TableInfo> baseTables, Map<String, Class<? extends ISchemaUpdateSnippet>> updateSnippets) {
        SchemaEngineFactoryImpl schemaEngineFactory = new SchemaEngineFactoryImpl();
        ISchemaEngine defaultSchemaEngine = schemaEngineFactory.newSchemaEngine();
        this.setSchemaEngine(defaultSchemaEngine);
        this.setBaseVersion(baseVersion);
        this.setBaseTables(baseTables);
        this.setUpateSnippets(updateSnippets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws SchemaManagementException {
        log.info("setting up database schema: performing initial checks...");
        if (this.dataSource == null) {
            throw new IllegalArgumentException("Improper Configuration. No dataSource present");
        }
        if ((this.baseTables == null || this.baseTables.isEmpty()) ^ this.baseMigration != null) {
            throw new IllegalArgumentException("Improper Configuration. No table list set");
        }
        try {
            this.schemaEngine.setConnection(this.dataSource.getConnection());
            this.schemaEngine.getDialect().setProperties(this.dialectProperties);
        }
        catch (SQLException e) {
            throw new SchemaManagementException("Cannot create initial connection to DB, check your configuration", e);
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("Checking for {} table...", (Object)this.versionHistoryTable);
            }
            TableInfo versionHistory = SchemaManager.makeVersionHistoryInfo(this.versionHistoryTable, this.versionHistorySchema);
            TableInfo check = this.withSchema(this.versionHistorySchema, () -> {
                try {
                    return this.schemaEngine.fetchTableInfo(this.versionHistoryTable, null);
                }
                catch (SQLException e) {
                    if (log.isDebugEnabled()) {
                        log.debug("Caught SQLException [{}]; Expected clear database, attempting database setup from scratch...", (Object)e.getMessage());
                    }
                    this.setupDB();
                    this.initUpdate();
                    return null;
                }
            });
            if (check == null) {
                return;
            }
            List<ColumnInfo> columns = check.getColumns();
            if (columns.size() != 4) {
                throw new SchemaManagementException("Table " + versionHistory.getName() + " has not 4 columns");
            }
            for (int i = 0; i < 4; ++i) {
                if (columns.get(i).getName().equalsIgnoreCase(versionHistory.getColumns().get(i).getName())) continue;
                throw new SchemaManagementException("Column [" + i + "] of table " + versionHistory.getName() + " has wrong name [" + columns.get(i).getName() + "]  (expected [" + versionHistory.getColumns().get(i).getName() + "]).");
            }
            if (log.isDebugEnabled()) {
                log.debug("Found {}; Initiating schema-update...", (Object)this.versionHistoryTable);
            }
            this.initUpdate();
        }
        finally {
            Connection conn = this.schemaEngine.getConnection();
            try {
                this.schemaEngine.setConnection(null);
                conn.close();
            }
            catch (SQLException e) {
                throw new SchemaManagementException("Error closing connection to DB, please chack your database manually", e);
            }
        }
    }

    protected void setupDB() throws SchemaManagementException {
        log.info("Setting up initial database with version [{}]...", (Object)this.baseVersion);
        boolean success = false;
        try {
            this.schemaEngine.createTable(SchemaManager.makeVersionHistoryInfo(this.versionHistoryTable, this.versionHistorySchema), false);
            this.schemaEngine.commit();
            log.info("Initial database with version [{}] has successfully been setup.", (Object)this.baseVersion);
            success = true;
        }
        catch (SQLException e) {
            throw new SchemaManagementException("Caught SQLException while setting up initial database", e);
        }
        finally {
            if (!success) {
                try {
                    this.schemaEngine.rollback();
                }
                catch (Throwable e) {
                    log.warn("Error rolling back the schema after an error setting up the intial database, your database may neeed manual cleanup", e);
                }
            }
        }
    }

    protected void initUpdate() throws SchemaManagementException {
        log.info("Performing database schema update...");
        try {
            SchemaCheckerBean schemaChecker = new SchemaCheckerBean(this.schemaEngine, this.updateSnippets, SchemaManager.makeVersionHistoryInfo(this.versionHistoryTable, this.versionHistorySchema), this.getInitialMigration());
            schemaChecker.checkSchema();
        }
        catch (InstantiationException e) {
            throw new SchemaManagementException("InstantiationException while updating schema", e);
        }
        catch (IllegalAccessException e) {
            throw new SchemaManagementException("Caught IllegalAccessException while updating schema", e);
        }
        catch (SQLException e) {
            throw new SchemaManagementException("Caught SQLException while updating schema", e);
        }
    }

    public ISchemaUpdateSnippet getInitialMigration() {
        return this.baseMigration == null ? new ISchemaUpdateSnippet(){

            @Override
            public String getTargetVersion() {
                return SchemaManager.this.baseVersion;
            }

            @Override
            public String getUpdateComment() {
                return SchemaManager.this.baseDescription;
            }

            @Override
            public void performUpdate(ISchemaEngine schemaEngine) throws SQLException {
                for (TableInfo table : SchemaManager.this.baseTables) {
                    schemaEngine.createTable(table, false);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Created Table [{}]", (Object)table.getName());
                }
                for (TableInfo tableInfo : SchemaManager.this.baseTables) {
                    schemaEngine.createForeignKeys(tableInfo);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Created Foreign Keys for Table [{}]", (Object)tableInfo.getName());
                }
            }
        } : this.baseMigration;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public ISchemaEngine getSchemaEngine() {
        return this.schemaEngine;
    }

    public void setSchemaEngine(ISchemaEngine schemaEngine) {
        this.schemaEngine = schemaEngine;
    }

    public String getBaseVersion() {
        return this.baseVersion;
    }

    public void setBaseVersion(String baseVersion) {
        this.baseVersion = baseVersion;
    }

    public String getBaseDescription() {
        return this.baseDescription;
    }

    public void setBaseDescription(String baseDescription) {
        this.baseDescription = baseDescription;
    }

    public List<TableInfo> getBaseTables() {
        return this.baseTables;
    }

    public void setBaseTables(List<TableInfo> tables) {
        this.baseTables = tables;
    }

    public Map<String, Class<? extends ISchemaUpdateSnippet>> getUpateSnippets() {
        return this.updateSnippets.entrySet().stream().map(a -> new Pair((Object)((String)a.getKey()), ((ISchemaUpdateSnippet)a.getValue()).getClass())).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    public void setUpateSnippets(Map<String, Class<? extends ISchemaUpdateSnippet>> upateSnippets) {
        this.updateSnippets = upateSnippets.entrySet().stream().map(a -> new Pair((Object)((String)a.getKey()), (Object)((ISchemaUpdateSnippet)SchemaManager.construct((Class)a.getValue())))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    private static final <T> T construct(Class<? extends T> clazz) {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public String getVersionHistoryTable() {
        return this.versionHistoryTable;
    }

    public void setVersionHistoryTable(String versionHistoryTable) {
        this.versionHistoryTable = versionHistoryTable;
    }

    public void setVersionHistorySchema(String versionHistorySchema) {
        this.versionHistorySchema = versionHistorySchema;
    }

    public void setDialectProperty(String key, String value) {
        if (this.dialectProperties == null) {
            this.dialectProperties = new HashMap<String, String>();
        }
        this.dialectProperties.put(key, value);
    }

    public Map<String, String> getDialectProperties() {
        return this.dialectProperties;
    }

    public void setDialectProperties(Map<String, String> dialectProperties) {
        this.dialectProperties = dialectProperties;
    }

    public void setUpdateSnippetInstances(Map<String, ISchemaUpdateSnippet> updateSnippetInstances) {
        this.updateSnippets = updateSnippetInstances;
    }

    public Map<String, ISchemaUpdateSnippet> getUpdateSnippetInstances() {
        return this.updateSnippets;
    }

    public void setBaseMigration(Class<? extends ISchemaUpdateSnippet> baseMigration) {
        this.baseMigration = SchemaManager.construct(baseMigration);
    }

    public void setBaseMigrationInstance(ISchemaUpdateSnippet baseMigration) {
        this.baseMigration = baseMigration;
    }
}

